------------------------------------------------------------------------------------------------------------------------

-- XP_671231_PBEM_Set_A03.lua

-- Author: Jason Petho
-- Scripter: Jason Petho
-- Date: 20220221
-- Version: 1.10 UPDATE

------------------------------------------------------------------------------------------------------------------------

function on_startup () -- DO NOT REMOVE

    -- set/unset optional rules (effective in on_startup() only!)
    -- for example:
    -- set_option(OPTHISTORICALLZS)
    -- unset_option(OPTFACING)
    -- to specify every optional rule:
    -- set_options(OPTFIREMAP|OPTEXTFOW|OPTCOMMANDCTRL|OPTVISIBILITY)

    -- set/unset move tracking globally (maybe unset if performance lags)
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()
    init_variables ()

    set_org_lists()

end

------------------------------------------------------------------------------------------------------------------------

function on_resume () -- DO NOT REMOVE

    -- see on_startup()
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()

    set_org_lists(current_turn(), current_side())

end

------------------------------------------------------------------------------------------------------------------------

function init_constants ()

    -- initialize names and labels unvarying through the course of the scenario
    -- also define here lists with "holes" (index gaps) (such lists are not saved)
    -- called in on_startup(), and potentially again (and again) in any subsequent on_resume()

    -- Side "a" and "b" values with descriptive names
    SIDE_A = "a" -- _NATION ## (in user.lua)
    US_SIDE = SIDE_A
    SIDE_B = "b" -- _NATION ## (in user.lua)
    CHINESE_SIDE = SIDE_B

    OBJECTIVES = {}
    OBJECTIVES[1] = "42,75" -- 1-20[1/1] 10
    OBJECTIVES[2] = "44,69" -- 1-20[1/1] 0
    OBJECTIVES[3] = "53,68" -- 1-20[1/1] 0
    OBJECTIVES[4] = "53,77" -- 1-20[1/1] 10
    OBJECTIVES[5] = "59,58" -- 1-20[1/1] 0
    OBJECTIVES[6] = "62,79" -- 1-20[1/1] 10
    OBJECTIVES[7] = "62,84" -- 1-20[1/1] 10
    OBJECTIVES[8] = "64,66" -- 1-20[1/1] 0
    OBJECTIVES[9] = "64,71" -- 1-20[1/1] 0
    OBJECTIVES[10] = "64,74" -- 1-20[1/1] 10

    EMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- EMBARK_PTS[1] = "45,69"
    -- ...
    -- Side B
    -- ...
    -- EMBARK_PTS[x] = "20,48"

    DISEMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- DISEMBARK_PTS[1] = "41,69"
    -- ...
    -- Side B
    -- ...
    -- DISEMBARK_PTS[x] = "13,56"

    -- others ...

    PHUM_DAK_POR = {OBJECTIVES[5]}
    NORTHWEST_VILLAGES = {OBJECTIVES[2],OBJECTIVES[3]}
    NORTHEAST_VILLAGES = {OBJECTIVES[8],OBJECTIVES[9]}
    SOUTHEAST_VILLAGES = {OBJECTIVES[6],OBJECTIVES[10]}
    SOUTHWEST_VILLAGES = {OBJECTIVES[1],OBJECTIVES[4]}
    PHUM_CHRAK_KRANH = {OBJECTIVES[7]}

end

------------------------------------------------------------------------------------------------------------------------

function set_org_lists (turn, side)

    -- called in on_startup(), in every on_next_turn(), and potentially again (and again) in any subsequent on_resume()

    --traceon()

    turn = turn or 1
    side = side or "a"

    ALLA = counters_all(SIDE_A)
    ALLB = counters_all(SIDE_B)

    -- auto-generated org lists to follow; rename, resequence, regroup, and reorganize as necessary

    -- KEY:

    -- [P] Platoon
    -- [C] Company
    -- [B] Battalion
    -- [R] Regiment
    -- [G] Brigade
    -- [D] Division
    -- [K] Corps
    -- [A] Army

    _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 = {2,200,4,5,6,10,11,12,17,18,19,23,24,25,47,48,49,50,205,206,207,208,52,53,202,45,201} -- [B] [0012267] PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP

    _INF_BTN_HQ_2 = {2} -- [P] [59,58] [003009] Battalion HQ 49 (foot)

    _COMMANDER_200 = {200} -- [P] [59,58] [004002] Commander 2

    _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 = {4,5,6,10,11,12} -- [C] [0002301] 1st PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_4 = {4} -- [P] [56,60] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_5 = {5} -- [P] [61,63] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_6 = {6} -- [P] [62,63] [002024] PLA Mechanized Platoon 65 A
    _TYPE_86_APC_10 = {10} -- [P] [56,60] [007011] Type 86 IFV
    _TYPE_86_APC_11 = {11} -- [P] [61,63] [007011] Type 86 IFV
    _TYPE_86_APC_12 = {12} -- [P] [62,63] [007011] Type 86 IFV

    _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 = {17,18,19,23,24,25} -- [C] [0002301] 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_17 = {17} -- [P] [55,62] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_18 = {18} -- [P] [61,62] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_19 = {19} -- [P] [55,62] [002024] PLA Mechanized Platoon 65 A
    _TYPE_86_APC_23 = {23} -- [P] [55,62] [007011] Type 86 IFV
    _TYPE_86_APC_24 = {24} -- [P] [55,62] [007011] Type 86 IFV
    _TYPE_86_APC_25 = {25} -- [P] [61,62] [007011] Type 86 IFV

    _1ST_TANK_COY_54_TYPE_59_70VP_46 = {47,48,49,50} -- [C] [0000208] 1st Tank Company 54 - Type 59 - 70VP
    _HQ_PLT_47 = {47} -- [P] [55,61] [000024] Type 59 Medium Tanks
    _1ST_PLT_48 = {48} -- [P] [55,61] [000022] Type 59 Medium Tanks
    _2ND_PLT_49 = {49} -- [P] [54,62] [000022] Type 59 Medium Tanks
    _3RD_PLT_50 = {50} -- [P] [54,62] [000022] Type 59 Medium Tanks

    _2ND_TANK_COY_54_TYPE_59_70VP_204 = {205,206,207,208} -- [C] [0000208] 2nd Tank Company 54 - Type 59 - 70VP
    _HQ_PLT_205 = {205} -- [P] [63,64] [000024] Type 59 Medium Tanks
    _1ST_PLT_206 = {206} -- [P] [63,64] [000022] Type 59 Medium Tanks
    _2ND_PLT_207 = {207} -- [P] [62,63] [000022] Type 59 Medium Tanks
    _3RD_PLT_208 = {208} -- [P] [62,63] [000022] Type 59 Medium Tanks

    _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 = {52,53} -- [C] [0001259] Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    _TYPE_85_122MM_HOWITZERS_52 = {52} -- [P] [60,57] [001027] Type 85 122mm Howitzers
    _TRUCKS_53 = {53} -- [P] [60,57] [007034] Zil Trucks

    _LOGISTICS_COY_LEVEL_1_42 = {202} -- [C] [0009210] Logistics Company - Level 1

    _MOBILE_SUPPLY_202 = {202} -- [P] [59,57] [003028] Mobile Supply

    _TYPE_86_45 = {45} -- [P] [59,58] [007012] Type 86 IFV

    _JEEPS_201 = {201} -- [P] [59,58] [007048] Jeeps

    _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 = {95,97,108,109,110,113,114,115,117,118,119,122,123,124,210,211,212,213,144,145,146,147,184,185,135,140,142} -- [B] [1012315] Mechanized Infantry Battalion 67 - B - Vietnam - 0VP

    _BTN_HQ_95 = {95} -- [P] [62,85] [103011] Battalion HQ (foot)

    _COMMANDER_97 = {97} -- [P] [62,85] [104001] Commander 1

    _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 = {108,109,110,113,114,115} -- [C] [1002391] A Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_108 = {108} -- [P] [52,87] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_109 = {109} -- [P] [53,89] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_110 = {110} -- [P] [52,86] [102047] Mechanized Rifle Platoon 67 B
    _M113A1_113 = {113} -- [P] [53,89] [107021] M113A1 APC
    _M113A1_114 = {114} -- [P] [52,86] [107021] M113A1 APC
    _M113A1_115 = {115} -- [P] [52,87] [107021] M113A1 APC

    _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 = {117,118,119,122,123,124} -- [C] [1002391] B Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_117 = {117} -- [P] [61,84] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_118 = {118} -- [P] [62,83] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_119 = {119} -- [P] [60,83] [102047] Mechanized Rifle Platoon 67 B
    _M113A1_122 = {122} -- [P] [61,84] [107021] M113A1 APC
    _M113A1_123 = {123} -- [P] [62,83] [107021] M113A1 APC
    _M113A1_124 = {124} -- [P] [60,83] [107021] M113A1 APC

    _1ST_TANK_COY_62_M48_0VP_209 = {210,211,212,213} -- [C] [1006231] 1st Tank Company 62 - M48 - 0VP
    _M48_210 = {210} -- [P] [52,86] [100074] M48 Roller
    _M48_211 = {211} -- [P] [51,85] [100021] M48 Patton
    _M48_212 = {212} -- [P] [53,86] [100021] M48 Patton
    _M48_213 = {213} -- [P] [53,86] [100021] M48 Patton

    _2ND_TANK_COY_66_M48A3_VIETNAM_0VP_143 = {144,145,146,147} -- [C] [1000290] 2nd Tank Company 66 - M48A3 - Vietnam - 0VP
    _M48_144 = {144} -- [P] [60,82] [100074] M48 Roller
    _M48_145 = {145} -- [P] [60,82] [100021] M48 Patton
    _M48_146 = {146} -- [P] [61,83] [100021] M48 Patton
    _M48_147 = {147} -- [P] [61,83] [100021] M48 Patton

    _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 = {184,185} -- [C] [1001323] Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    _M114_155MM_184 = {184} -- [P] [61,86] [101553] M114 155mm Howitzers
    _M35_185 = {185} -- [P] [61,86] [107436] 2 1/2 ton truck armed

    _LOGISTICS_COY_LEVEL_1_62_134 = {135} -- [C] [1009292] Logistics Company - Level 1 - 62

    _SUPPLY_TRUCKS_135 = {135} -- [P] [62,86] [106816] Supply Trucks (VP)

    _M577_140 = {140} -- [P] [62,85] [107072] M577 Command Vehicle

    _M151_142 = {142} -- [P] [62,85] [107065] 1/4 ton truck

    -- hand-crafted org lists, if any, to follow

    --traceoff()

	CHINESE_COYS = {3,16,46,204}
	US_COYS = {107,116,209,143}
    CHINESE_SUPPLY_GROUP = {2,42}
    US_SUPPLY_GROUP = {95,135}

end

------------------------------------------------------------------------------------------------------------------------

function init_variables ()

    -- initialize values possibly varying through the course of the scenario
    -- called once only, in on_startup()

    -- embark/disembark points
    -- for example:
    -- _D303_VC_MAIN_FORCE_INF_BTN_2ND_RIFLE_COY_EMBARK_PT = random_index(3,5)

    -- target points
    -- for example:
    -- _MACV_GUNSHIPS_TARGET_PT = random_pick({1,2,3,4,5,6,7,8,12})

    -- others ...
    -- for example:
    -- NUMBER_VC_ATTACKS = 0
    -- _2ND_ARVN_MARINE_BTN_LEADERLESS = false
    -- NUMBER_US_AIRSTRIKES = air_support("a")
    -- BATTLE_PLAN_HMONG = dieroll(2)

end

------------------------------------------------------------------------------------------------------------------------

function show_briefing (side) -- DO NOT REMOVE

    -- player briefings

    if side == SIDE_A then

--[[
            memo("Side A Briefing", 
                   "SIDE B PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the VC Player, or Side B. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("SMEAC", 
                   "Battle of the Plain\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Friendly Forces: You are in command of a battalion sized mechanized task force.\n" .. 
                   "\n" .. 
                   "Enemy Forces: Chinese tanks and APC's are reported operating in the area.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the advance north and secure the areas north of the border.\n" ..
                   "Your Secondary Mission is to track down and destroy the opposing headquarters, supply and artillery.\n" ..  
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Use your battlegroups to advance north and secure the areas as quickly as possible. Watch out for American tanks and infantry.\n" ..
                   "Once secured, track down and destroy the opposing headquarters, suppy and artillery to ensure total victory.\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Additional supplies are not expected, but keep your supply unit close to your headquarters to maintain supply.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\
",
                   side, side
                  )

    elseif side == SIDE_B then

--[[
            memo("Side B Briefing", 
                   "SIDE A PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the US Player, or Side A. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("Side B Briefing", 
                   "Battle of ...\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "...\n" ..
                   "\n" .. 
                   "Friendly Forces: You are in command of a battalion sized mechanized task force.\n" .. 
                   "\n" .. 
                   "Enemy Forces: American tanks and APC's are reported operating in the area.\n" ..
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the advance south and secure the areas north of the border, as well as Phum Chrak Kranh.\n" ..
                   "Your Secondary Mission is to track down and destroy the opposing headquarters, supply and artillery.\n" ..  
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Use your battlegroups to advance south and secure the areas as quickly as possible. Watch out for American tanks and infantry.\n" ..
                   "Once secured, track down and destroy the opposing headquarters, suppy and artillery to ensure total victory.\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Additional supplies are not expected, but keep your supply unit close to your headquarters to maintain supply.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    end

end

------------------------------------------------------------------------------------------------------------------------

function on_shutdown () -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------
    
function on_next_turn (turn) -- DO NOT REMOVE
    

    -- after first (in)direct fire, Side A loses (arty) supply each turn
    if SIDE_A_FIRED then
        inc_ammo_level(SIDE_A, -2)
    end
    if SIDE_A_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_A, -2)
    end

    -- after first (in)direct fire, Side B loses (arty) supply each turn
    if SIDE_B_FIRED then
        inc_ammo_level(SIDE_B, -2)
    end
    if SIDE_B_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_B, -2)
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_next_phase (turn, side) -- DO NOT REMOVE

    -- for testing purposes; note that these might override player selected options!
    -- by default, in normal game play, the player selected options apply;
    -- by default, in auto-test mode, FOW is OFF, all the time, for both sides
    if is_test_trial_play() and not is_qa_testing() then
        set_fow(side, 0) -- for current side, set FOW OFF
        set_fow(other_side(side), 1) -- for opposing side, set FOW ON
    end

    set_org_lists(turn, side)

    if turn == 1 then
        show_briefing(side)
    end

    battle_plan(turn, side)

--[[ commonly used, uncomment and adapt as necessary:
    -- every phase, adjust downward the NVA assault_attack_aggressiveness_effect bonus per their current loss rate
    adjust_adaptive_ai (sideof(NORTH_VIETNAM_NATION), NORTH_VIETNAM_NATION, "assault_attack_aggressiveness_effect", - math.floor(total_loss_rate(sideof(NORTH_VIETNAM_NATION))/2))
--]]

    if DEBUG then  -- where DEBUG is set in user.lua
        csee_check(turn, side)
    end

    -- Supply bonus for Chinese Side if keeping supply near HQ during noted turns
    if turn == 4 or
        turn == 8 or
        turn == 12 or
        turn == 16 then
        if (counters_extent(CHINESE_SUPPLY_GROUP) < 2) then
            inc_ammo_level(CHINESE_SIDE, 5) 
            inc_arty_ammo_level(CHINESE_SIDE, 5) 
            message("Chinese Reminder Supply Cohesion",
            "Keep your supply close to your Headquarters to continue gaining additional supply!",CHINESE_SIDE, CHINESE_SIDE)
        end
    end

    -- Supply bonus for US Side if keeping supply near HQ during noted turns
    if turn == 4 or
        turn == 8 or
        turn == 12 or
        turn == 16 then
        if (counters_extent(US_SUPPLY_GROUP) < 2) then
            inc_ammo_level(US_SIDE, 5) 
            inc_arty_ammo_level(US_SIDE, 5) 
            message("US Reminder Supply Cohesion",
            "Keep your supply close to your Headquarters to continue gaining additional supply!",US_SIDE, US_SIDE)
        end
    end


    if side == US_SIDE then

        -- US gains for securing PHUM_CHRAK_KRANH
        if owned(PHUM_CHRAK_KRANH, US_SIDE) then
            TURNS_US_HOLD_PHUM_CHRAK_KRANH = (TURNS_US_HOLD_PHUM_CHRAK_KRANH or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_CHRAK_KRANH " .. TURNS_US_HOLD_PHUM_CHRAK_KRANH)
            if TURNS_US_HOLD_PHUM_CHRAK_KRANH == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_CHRAK_KRANH 3", "For holding the village of Phum Chrak Kranh for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAK_KRANH == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_CHRAK_KRANH 5", "For holding the village of Phum Chrak Kranh for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAK_KRANH == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds PHUM_CHRAK_KRANH 7", "For holding the village of Phum Chrak Kranh for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAK_KRANH == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_CHRAK_KRANH 9", "For holding the village of Phum Chrak Kranh for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAK_KRANH == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds PHUM_CHRAK_KRANH 11", "For holding the village of Phum Chrak Kranh for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAK_KRANH == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds PHUM_CHRAK_KRANH 13", "For holding the village of Phum Chrak Kranh for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_DAK_POR
        if owned(PHUM_DAK_POR, US_SIDE) then
            TURNS_US_HOLD_PHUM_DAK_POR = (TURNS_US_HOLD_PHUM_DAK_POR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_DAK_POR " .. TURNS_US_HOLD_PHUM_DAK_POR)
            if TURNS_US_HOLD_PHUM_DAK_POR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_DAK_POR 3", "For holding the village of Phum Dak Por for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_DAK_POR == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_DAK_POR 5", "For holding the village of Phum Dak Por for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_DAK_POR == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds PHUM_DAK_POR 7", "For holding the village of Phum Dak Por for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_DAK_POR == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_DAK_POR 9", "For holding the village of Phum Dak Por for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_DAK_POR == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds PHUM_DAK_POR 11", "For holding the village of Phum Dak Por for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_DAK_POR == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds PHUM_DAK_POR 13", "For holding the village of Phum Dak Por for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing SOUTHWEST_VILLAGES
        if owned(SOUTHWEST_VILLAGES, US_SIDE) then
            TURNS_US_HOLD_SOUTHWEST_VILLAGES = (TURNS_US_HOLD_SOUTHWEST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_SOUTHWEST_VILLAGES " .. TURNS_US_HOLD_SOUTHWEST_VILLAGES)
            if TURNS_US_HOLD_SOUTHWEST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds SOUTHWEST_VILLAGES 3", "For holding the southwest villages for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHWEST_VILLAGES == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds SOUTHWEST_VILLAGES 5", "For holding the southwest villages for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHWEST_VILLAGES == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds SOUTHWEST_VILLAGES 7", "For holding the southwest villages for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHWEST_VILLAGES == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds SOUTHWEST_VILLAGES 9", "For holding the southwest villages for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHWEST_VILLAGES == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds SOUTHWEST_VILLAGES 11", "For holding the southwest villages for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHWEST_VILLAGES == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds SOUTHWEST_VILLAGES 13", "For holding the southwest villages for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing SOUTHEAST_VILLAGES
        if owned(SOUTHEAST_VILLAGES, US_SIDE) then
            TURNS_US_HOLD_SOUTHEAST_VILLAGES = (TURNS_US_HOLD_SOUTHEAST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_SOUTHEAST_VILLAGES " .. TURNS_US_HOLD_SOUTHEAST_VILLAGES)
            if TURNS_US_HOLD_SOUTHEAST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds SOUTHEAST_VILLAGES 3", "For holding the southeast villages for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHEAST_VILLAGES == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds SOUTHEAST_VILLAGES 5", "For holding the southeast villages for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHEAST_VILLAGES == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds SOUTHEAST_VILLAGES 7", "For holding the southeast villages for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHEAST_VILLAGES == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds SOUTHEAST_VILLAGES 9", "For holding the southeast villages for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHEAST_VILLAGES == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds SOUTHEAST_VILLAGES 11", "For holding the southeast villages for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_SOUTHEAST_VILLAGES == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds SOUTHEAST_VILLAGES 13", "For holding the southeast villages for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing NORTHEAST_VILLAGES
        if owned(NORTHEAST_VILLAGES, US_SIDE) then
            TURNS_US_HOLD_NORTHEAST_VILLAGES = (TURNS_US_HOLD_NORTHEAST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_NORTHEAST_VILLAGES " .. TURNS_US_HOLD_NORTHEAST_VILLAGES)
            if TURNS_US_HOLD_NORTHEAST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds NORTHEAST_VILLAGES 3", "For holding the northeast villages for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHEAST_VILLAGES == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds NORTHEAST_VILLAGES 5", "For holding the northeast villages for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHEAST_VILLAGES == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds NORTHEAST_VILLAGES 7", "For holding the northeast villages for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHEAST_VILLAGES == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds NORTHEAST_VILLAGES 9", "For holding the northeast villages for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHEAST_VILLAGES == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds NORTHEAST_VILLAGES 11", "For holding the northeast villages for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHEAST_VILLAGES == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds NORTHEAST_VILLAGES 13", "For holding the northeast villages for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing NORTHWEST_VILLAGES
        if owned(NORTHWEST_VILLAGES, US_SIDE) then
            TURNS_US_HOLD_NORTHWEST_VILLAGES = (TURNS_US_HOLD_NORTHWEST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_NORTHWEST_VILLAGES " .. TURNS_US_HOLD_NORTHWEST_VILLAGES)
            if TURNS_US_HOLD_NORTHWEST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds NORTHWEST_VILLAGES 3", "For holding the northwest villages for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHWEST_VILLAGES == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds NORTHWEST_VILLAGES 5", "For holding the northwest villages for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHWEST_VILLAGES == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds NORTHWEST_VILLAGES 7", "For holding the northwest villages for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHWEST_VILLAGES == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds NORTHWEST_VILLAGES 9", "For holding the northwest villages for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHWEST_VILLAGES == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds NORTHWEST_VILLAGES 11", "For holding the northwest villages for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_NORTHWEST_VILLAGES == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds NORTHWEST_VILLAGES 13", "For holding the northwest villages for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

    end

    if side == CHINESE_SIDE then

        -- CHINESE gains for securing NORTHWEST_VILLAGES
        if owned(NORTHWEST_VILLAGES, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES = (TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES " .. TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES)
            if TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 3", "For holding the northwest villages for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 5", "For holding the northwest villages for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 7", "For holding the northwest villages for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 9", "For holding the northwest villages for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 11", "For holding the northwest villages for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHWEST_VILLAGES == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds NORTHWEST_VILLAGES 13", "For holding the northwest villages for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing NORTHEAST_VILLAGES
        if owned(NORTHEAST_VILLAGES, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES = (TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES " .. TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES)
            if TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 3", "For holding the northeast villages for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 5", "For holding the northeast villages for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 7", "For holding the northeast villages for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 9", "For holding the northeast villages for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 11", "For holding the northeast villages for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_NORTHEAST_VILLAGES == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds NORTHEAST_VILLAGES 13", "For holding the northeast villages for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing SOUTHEAST_VILLAGES
        if owned(SOUTHEAST_VILLAGES, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES = (TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES " .. TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES)
            if TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 3", "For holding the southeast villages for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 5", "For holding the southeast villages for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 7", "For holding the southeast villages for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 9", "For holding the southeast villages for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 11", "For holding the southeast villages for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHEAST_VILLAGES == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds SOUTHEAST_VILLAGES 13", "For holding the southeast villages for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing SOUTHWEST_VILLAGES
        if owned(SOUTHWEST_VILLAGES, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES = (TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES " .. TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES)
            if TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 3", "For holding the southwest villages for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 5", "For holding the southwest villages for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 7", "For holding the southwest villages for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 9", "For holding the southwest villages for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 11", "For holding the southwest villages for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_SOUTHWEST_VILLAGES == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds SOUTHWEST_VILLAGES 13", "For holding the southwest villages for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_DAK_POR
        if owned(PHUM_DAK_POR, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_DAK_POR = (TURNS_CHINESE_HOLD_PHUM_DAK_POR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_DAK_POR " .. TURNS_CHINESE_HOLD_PHUM_DAK_POR)
            if TURNS_CHINESE_HOLD_PHUM_DAK_POR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_DAK_POR 3", "For holding the village of Phum Dak Por for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_DAK_POR == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_DAK_POR 5", "For holding the village of Phum Dak Por for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_DAK_POR == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds PHUM_DAK_POR 7", "For holding the village of Phum Dak Por for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_DAK_POR == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_DAK_POR 9", "For holding the village of Phum Dak Por for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_DAK_POR == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds PHUM_DAK_POR 11", "For holding the village of Phum Dak Por for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_DAK_POR == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds PHUM_DAK_POR 13", "For holding the village of Phum Dak Por for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_CHRAK_KRANH
        if owned(PHUM_CHRAK_KRANH, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH = (TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH " .. TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH)
            if TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 3", "For holding the village of Phum Chrak Kranh for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 5", "For holding the village of Phum Chrak Kranh for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 7", "For holding the village of Phum Chrak Kranh for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 9", "For holding the village of Phum Chrak Kranh for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 11", "For holding the village of Phum Chrak Kranh for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAK_KRANH == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds PHUM_CHRAK_KRANH 13", "For holding the village of Phum Chrak Kranh for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

    end


end

------------------------------------------------------------------------------------------------------------------------

function battle_plan (turn, side)

    -- UNLEASH is true if game launched with -U switch, or if Ctrl+Alt+U in game
    -- Ctrl+Alt+U is a toggle, so will set UNLEASH to false after an earlier Ctrl+Alt+U (setting UNLEASH to true)
    if UNLEASH then
        unleash(ALLA)
        unleash(ALLB)
        return
    end

    if side == SIDE_A and is_ai(side) then

        --traceon()
        battle_plan_a(turn, side)
        --traceoff()

    elseif side == SIDE_B and is_ai(side) then

        --traceon()
        battle_plan_b(turn, side)
        --traceoff()

    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_a (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side A units hold initially (or maybe use halt())
        hold(ALLA)
    end


--[[

    -----------------------------------------------------------------------------------------------------
    -- _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 -- Mechanized Infantry Battalion 67 - B - Vietnam - 0VP --
    -----------------------------------------------------------------------------------------------------

    -- _BTN_HQ_95 -- Battalion HQ (foot)
    do local units = _BTN_HQ_95

    end

    -- _COMMANDER_97 -- Commander 1
    do local units = _COMMANDER_97

    end

    -- _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 -- A Mechanized Infantry Company 67 - B - Vietnam
    do local units = _A_MECHANIZED_INF_COY_67_B_VIETNAM_107

    end

    -- _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 -- B Mechanized Infantry Company 67 - B - Vietnam
    do local units = _B_MECHANIZED_INF_COY_67_B_VIETNAM_116

    end

    -- _1ST_TANK_COY_62_M48_0VP_209 -- 1st Tank Company 62 - M48 - 0VP
    do local units = _1ST_TANK_COY_62_M48_0VP_209

    end

    -- _2ND_TANK_COY_66_M48A3_VIETNAM_0VP_143 -- 2nd Tank Company 66 - M48A3 - Vietnam - 0VP
    do local units = _2ND_TANK_COY_66_M48A3_VIETNAM_0VP_143

    end

    -- _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 -- Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    do local units = _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183

    end
    -- _M114_155MM_184 -- M114 155mm Howitzers

    -- _LOGISTICS_COY_LEVEL_1_62_134 -- Logistics Company - Level 1 - 62
    do local units = _LOGISTICS_COY_LEVEL_1_62_134

    end

    -- _SUPPLY_TRUCKS_135 -- Supply Trucks (VP)
    do local units = _SUPPLY_TRUCKS_135

    end

    -- _M577_140 -- M577 Command Vehicle
    do local units = _M577_140

    end

    -- _M151_142 -- 1/4 ton truck
    do local units = _M151_142

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_b (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side B units hold initially (or maybe use halt())
        hold(ALLB)
    end


--[[

    ----------------------------------------------------------------------------------------------------------------
    -- _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 -- PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP --
    ----------------------------------------------------------------------------------------------------------------

    -- _INF_BTN_HQ_2 -- Battalion HQ 49 (foot)
    do local units = _INF_BTN_HQ_2

    end

    -- _COMMANDER_200 -- Commander 2
    do local units = _COMMANDER_200

    end

    -- _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 -- 1st PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3

    end

    -- _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 -- 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16

    end

    -- _1ST_TANK_COY_54_TYPE_59_70VP_46 -- 1st Tank Company 54 - Type 59 - 70VP
    do local units = _1ST_TANK_COY_54_TYPE_59_70VP_46

    end

    -- _2ND_TANK_COY_54_TYPE_59_70VP_204 -- 2nd Tank Company 54 - Type 59 - 70VP
    do local units = _2ND_TANK_COY_54_TYPE_59_70VP_204

    end

    -- _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 -- Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    do local units = _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51

    end
    -- _TYPE_85_122MM_HOWITZERS_52 -- Type 85 122mm Howitzers

    -- _LOGISTICS_COY_LEVEL_1_42 -- Logistics Company - Level 1
    do local units = _LOGISTICS_COY_LEVEL_1_42

    end

    -- _MOBILE_SUPPLY_202 -- Mobile Supply
    do local units = _MOBILE_SUPPLY_202

    end

    -- _TYPE_86_45 -- Type 86 IFV
    do local units = _TYPE_86_45

    end

    -- _JEEPS_201 -- Jeeps
    do local units = _JEEPS_201

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function on_objective_capture (hc, value, values, side) -- DO NOT REMOVE


    if chance(22) then -- 22% chance for player receiving a shout
        if side == CHINESE_SIDE then
            message("Commendations", US_COMMENDATIONS[dieroll(#US_COMMENDATIONS)], side, side)
        else
            message("Commendations", CHINESE_COMMENDATIONS[dieroll(#CHINESE_COMMENDATIONS)], side, side)
        end
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_move (hc_from, hc_to, trackid) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE


    if side == SIDE_A then
        SIDE_A_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_FIRED = true
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_arty_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE

    if side == SIDE_A then
        SIDE_A_ARTY_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_ARTY_FIRED = true
    end
end

------------------------------------------------------------------------------------------------------------------------

function on_unit_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, attype) -- DO NOT REMOVE

    -- lose EPs for friendly fire arty or air attacks only
    if side == current_side() then -- side is the target side
        if attype == INDIRECTFIRE_COMBAT then
            inc_event_points(side, -5)
        elseif attype == AIRSTRIKE_COMBAT then
            inc_event_points(side, -10)
        end
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reduce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, loss, combat) -- DO NOT REMOVE 

--[[ commonly used, uncomment, adapt and repeat as necessary:
    if has_flag(counter_unit_other_flags(trackid), HELICOPTER) then
        inc_event_points(SIDE_B, 25*loss)
        note("Notice", "For destroying " .. loss .. " helicopter" .. (((loss > 1) and "s") or "") .. ", the VC side gains " .. 25*loss .. " EPs.", "ab", "ab")
    end
--]]

company_reduce_check(trackid, US_COYS, {"American","Chinese"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
company_reduce_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())

end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_kill (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE

    do local units = join({_BTN_HQ_95, _COMMANDER_97})
        local award = 100
         if member(trackid, units) then
             inc_event_points(CHINESE_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
         end
     end
 
     do local units = _TYPE_85_122MM_HOWITZERS_52
        local award = 125
        if member(trackid, units) then
            inc_event_points(CHINESE_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
        end
    end
 
    do local units = _SUPPLY_TRUCKS_135
        local award = 150
        if member(trackid, units) then
            inc_event_points(CHINESE_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
        end
    end
 
    do local units = join({_INF_BTN_HQ_2, _COMMANDER_200})
        local award = 100
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end
   
    do local units = _M114_155MM_184
        local award = 125
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end

    do local units = _MOBILE_SUPPLY_202
        local award = 150
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end

    company_kill_check(trackid, US_COYS, {"American","Chinese"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
        
    company_kill_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reinforce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  there are no hc hex coordinates for on_unit_release()

function on_unit_release (trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_remove (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  0 is superior (surviving) unit, 1 is subordinate (disappearing) unit

function on_unit_merge (hc, trackid0, pid0, name0, side0, nation0, oid0, orgname0, points0, strength0, HQ0, Leader0, trackid1, pid1, name1, side1, nation1, oid1, orgname1, points1, strength1, HQ1, Leader1) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_top (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_bottom (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_clockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_counterclockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_attack (hc, side, nation, attype) -- DO NOT REMOVE

    -- lose EPs for indirect fire or airstrike vs. inhabited hex (village, city, suburb), whether or not occupied by the enemy
    -- side is the firing side
    if -- is_building_hex(hc) or
       is_habitat_hex(hc) then
        if not_occupied(hc, other_side(side)) then
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -2)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -5)
            end
        else -- occupied
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -1)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -2)
            end
        end
    end

end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_assault (hc, side) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_air_attack (hc, pid, name, side, nation, points, strength) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_arty_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------ 

function on_mine_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_ied_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_vehicle_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_light_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_lay_mine_field (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_set_ied (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_barrier (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_damage (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_improve_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_entrench_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_lz (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_hex (hc) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------
