------------------------------------------------------------------------------------------------------------------------

-- XP_671231_PBEM_Set_A02.lua

-- Author: Jason Petho
-- Scripter: Jason Petho
-- Date: 20220221
-- Version: 1.10 UPDATE

------------------------------------------------------------------------------------------------------------------------

function on_startup () -- DO NOT REMOVE

    -- set/unset optional rules (effective in on_startup() only!)
    -- for example:
    -- set_option(OPTHISTORICALLZS)
    -- unset_option(OPTFACING)
    -- to specify every optional rule:
    -- set_options(OPTFIREMAP|OPTEXTFOW|OPTCOMMANDCTRL|OPTVISIBILITY)

    -- set/unset move tracking globally (maybe unset if performance lags)
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()
    init_variables ()

    set_org_lists()

end

------------------------------------------------------------------------------------------------------------------------

function on_resume () -- DO NOT REMOVE

    -- see on_startup()
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()

    set_org_lists(current_turn(), current_side())

end

------------------------------------------------------------------------------------------------------------------------

function init_constants ()

    -- initialize names and labels unvarying through the course of the scenario
    -- also define here lists with "holes" (index gaps) (such lists are not saved)
    -- called in on_startup(), and potentially again (and again) in any subsequent on_resume()

    -- Side "a" and "b" values with descriptive names
    SIDE_A = "a" -- _NATION ## (in user.lua)
    US_SIDE = SIDE_A
    SIDE_B = "b" -- _NATION ## (in user.lua)
    CHINESE_SIDE = SIDE_B

    OBJECTIVES = {}
    OBJECTIVES[1] = "29,63" -- 1-20[1/1] 10
    OBJECTIVES[2] = "38,58" -- 1-20[1/1] 10
    OBJECTIVES[3] = "39,53" -- 1-20[1/1] 10
    OBJECTIVES[4] = "41,57" -- 1-20[1/1] 10
    OBJECTIVES[5] = "41,65" -- 1-20[1/1] 10
    OBJECTIVES[6] = "42,46" -- 1-20[1/1] 0
    OBJECTIVES[7] = "44,52" -- 1-20[1/1] 0
    OBJECTIVES[8] = "45,54" -- 1-20[1/1] 0
    OBJECTIVES[9] = "45,55" -- 1-20[1/1] 10
    OBJECTIVES[10] = "46,56" -- 1-20[1/1] 10
    OBJECTIVES[11] = "48,50" -- 1-20[1/1] 0
    OBJECTIVES[12] = "50,51" -- 1-20[1/1] 0
    OBJECTIVES[13] = "51,51" -- 1-20[1/1] 0
    OBJECTIVES[14] = "59,47" -- 1-20[1/1] 0

    LANDING_ZONES = {}
    LANDING_ZONES[1] = "20,62"
    LANDING_ZONES[2] = "27,66"
    LANDING_ZONES[3] = "38,61"
    LANDING_ZONES[4] = "46,51"
    LANDING_ZONES[5] = "59,44"
    LANDING_ZONES[6] = "65,50"
    LANDING_ZONES[7] = "71,51"

    EMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- EMBARK_PTS[1] = "45,69"
    -- ...
    -- Side B
    -- ...
    -- EMBARK_PTS[x] = "20,48"

    DISEMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- DISEMBARK_PTS[1] = "41,69"
    -- ...
    -- Side B
    -- ...
    -- DISEMBARK_PTS[x] = "13,56"

    -- others ...

    PHUM_SAMRAONG = {OBJECTIVES[7],OBJECTIVES[8],OBJECTIVES[9],OBJECTIVES[10]}
    PHUM_CHRAPEH = {OBJECTIVES[12],OBJECTIVES[13]}
    HIGHWAY_7_WEST = {OBJECTIVES[2],OBJECTIVES[4]}
    KH_DAR = {OBJECTIVES[1]}
    PHUM_CHNNGOR = {OBJECTIVES[3]}
    PHUM_CHNNGOR_KHANG_TBONG = {OBJECTIVES[6]}
    PHUM_TAKE = {OBJECTIVES[5]}
    HILL_93 = {OBJECTIVES[11]}
    HIGHWAY_7_EAST = {OBJECTIVES[14]}

end

------------------------------------------------------------------------------------------------------------------------

function set_org_lists (turn, side)

    -- called in on_startup(), in every on_next_turn(), and potentially again (and again) in any subsequent on_resume()

    --traceon()

    turn = turn or 1
    side = side or "a"

    ALLA = counters_all(SIDE_A)
    ALLB = counters_all(SIDE_B)

    -- auto-generated org lists to follow; rename, resequence, regroup, and reorganize as necessary

    -- KEY:

    -- [P] Platoon
    -- [C] Company
    -- [B] Battalion
    -- [R] Regiment
    -- [G] Brigade
    -- [D] Division
    -- [K] Corps
    -- [A] Army

    _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 = {2,200,4,5,6,8,17,18,19,21,30,31,32,34,48,52,53,55,56,58,62,63,64,66,67,68,71,81,82,91,202} -- [B] [0012267] PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP

    _INF_BTN_HQ_2 = {2} -- [P] [59,47] [003009] Battalion HQ 49 (foot)

    _COMMANDER_200 = {200} -- [P] [59,47] [004002] Commander 2

    _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 = {4,5,6,8} -- [C] [0002301] 1st PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_4 = {4} -- [P] [51,51] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_5 = {5} -- [P] [51,51] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_6 = {6} -- [P] [51,50] [002024] PLA Mechanized Platoon 65 A
    _RPG_SECTION_8 = {8} -- [P] [51,50] [009015] Type 69 RPG AT Team

    _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 = {17,18,19,21} -- [C] [0002301] 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_17 = {17} -- [P] [55,49] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_18 = {18} -- [P] [55,49] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_19 = {19} -- [P] [56,48] [002024] PLA Mechanized Platoon 65 A
    _RPG_SECTION_21 = {21} -- [P] [56,48] [009015] Type 69 RPG AT Team

    _3RD_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_29 = {30,31,32,34} -- [C] [0002301] 3rd PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_30 = {30} -- [P] [52,50] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_31 = {31} -- [P] [52,50] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_32 = {32} -- [P] [53,50] [002024] PLA Mechanized Platoon 65 A
    _RPG_SECTION_34 = {34} -- [P] [53,50] [009015] Type 69 RPG AT Team

    _TANK_COY_54_TYPE_59_70VP_46 = {48} -- [C] [0000208] Tank Company 54 - Type 59 - 70VP

    _1ST_PLT_48 = {48} -- [P] [56,48] [000022] Type 59 Medium Tanks

    _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 = {52,53} -- [C] [0001259] Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    _TYPE_85_122MM_HOWITZERS_52 = {52} -- [P] [60,44] [001027] Type 85 122mm Howitzers
    _TRUCKS_53 = {53} -- [P] [60,44] [007034] Zil Trucks

    _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54 = {55,56,58} -- [C] [0008228] Anti-Aircraft Machinegun Company 65 - 36VP
    _1ST_BTY_55 = {55} -- [P] [60,44] [008019] PLA Heavy Machine Gun 65
    _2ND_BTY_56 = {56} -- [P] [54,49] [008019] PLA Heavy Machine Gun 65
    _TRUCKS_58 = {58} -- [P] [60,44] [007033] ZiS-5 Trucks

    _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61 = {62,63,64,66,67,68} -- [C] [0006214] Armoured Reconnaissance Company 65 - Type 63 - 106VP
    _1ST_PLT_62 = {62} -- [P] [69,45] [002034] PLA Recon Platoon 55
    _2ND_PLT_63 = {63} -- [P] [70,45] [002034] PLA Recon Platoon 55
    _3RD_PLT_64 = {64} -- [P] [70,44] [002034] PLA Recon Platoon 55
    _TYPE_63_66 = {66} -- [P] [69,45] [007008] Type 63C APC
    _TYPE_63_67 = {67} -- [P] [70,45] [007008] Type 63C APC
    _TYPE_63_68 = {68} -- [P] [70,44] [007008] Type 63C APC

    _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70 = {71} -- [C] [0005210] PLA Motorized Engineer Company 65 - 132VP

    _1ST_PLT_71 = {71} -- [P] [51,50] [002069] PLA Engineer Platoon 65

    _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80 = {81,82} -- [C] [0007202] PLA Helicopter Gunship Company - Alouette III Gunship - 60VP
    _ALOUETTE_III_GUNSHIP_81 = {81} -- [P] [59,44] [006501] SA-316 Alouette III Gunship
    _ALOUETTE_III_GUNSHIP_82 = {82} -- [P] [59,44] [006501] SA-316 Alouette III Gunship

    _PLA_SMG_INF_COY_65_54VP_90 = {91} -- [C] [0002290] PLA SMG Infantry Company 65 - 54VP

    _1ST_PLT_91 = {91} -- [P] [54,49] [002031] PLA SMG Platoon 65

    _LOGISTICS_COY_LEVEL_1_42 = {202} -- [C] [0009210] Logistics Company - Level 1

    _MOBILE_SUPPLY_202 = {202} -- [P] [59,44] [003028] Mobile Supply

    _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 = {95,97,99,100,101,102,108,109,110,111,117,118,119,126,127,128,145,189,190,157,184,185,186,187,135} -- [B] [1012315] Mechanized Infantry Battalion 67 - B - Vietnam - 0VP

    _BTN_HQ_95 = {95} -- [P] [29,62] [103011] Battalion HQ (foot)

    _COMMANDER_97 = {97} -- [P] [29,62] [104001] Commander 1

    _HQ_AND_SERVICE_COY_67_MECHANIZED_98 = {99,100,101,102} -- [C] [1002389] Headquarters and Service Company 67 - Mechanized
    _1_RECONNAISSANCE_99 = {99} -- [P] [17,65] [102082] Reconnaissance 66
    _2_RECONNAISSANCE_100 = {100} -- [P] [20,62] [102082] Reconnaissance 66
    _M113A1_101 = {101} -- [P] [17,65] [107023] M113A1 APC
    _M113A1_102 = {102} -- [P] [20,62] [107023] M113A1 APC

    _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 = {108,109,110,111} -- [C] [1002391] A Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_108 = {108} -- [P] [32,61] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_109 = {109} -- [P] [32,61] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_110 = {110} -- [P] [31,62] [102047] Mechanized Rifle Platoon 67 B
    _1_WEAPONS_PLT_111 = {111} -- [P] [31,62] [109058] M113 106mm RR

    _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 = {117,118,119} -- [C] [1002391] B Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_117 = {117} -- [P] [35,60] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_118 = {118} -- [P] [35,60] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_119 = {119} -- [P] [34,60] [102047] Mechanized Rifle Platoon 67 B

    _C_MECHANIZED_INF_COY_67_B_VIETNAM_125 = {126,127,128} -- [C] [1002391] C Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_126 = {126} -- [P] [38,58] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_127 = {127} -- [P] [38,58] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_128 = {128} -- [P] [37,59] [102047] Mechanized Rifle Platoon 67 B

    _TANK_COY_66_M48A3_VIETNAM_0VP_143 = {145} -- [C] [1000290] Tank Company 66 - M48A3 - Vietnam - 0VP

    _M48_145 = {145} -- [P] [33,61] [100021] M48 Patton

    _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188 = {189,190} -- [C] [1007409] Assault Helicopter Company 67  - AH-1 - 0VP
    _1_1ST_WEAPONS_189 = {189} -- [P] [27,66] [106549] AH-1G Early Cobra(2L2H)
    _2_1ST_WEAPONS_190 = {190} -- [P] [27,66] [106549] AH-1G Early Cobra(2L2H)

    _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156 = {157} -- [C] [1005255] Motorized Engineer Company 66 - ROAD - 0VP

    _1ST_PLT_157 = {157} -- [P] [36,59] [102091] Engineer Platoon 66

    _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 = {184,185,186,187} -- [C] [1001323] Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    _M114_155MM_184 = {184} -- [P] [27,65] [101553] M114 155mm Howitzers
    _M35_185 = {185} -- [P] [27,65] [107436] 2 1/2 ton truck armed
    _M60_186 = {186} -- [P] [27,65] [102580] M60 Machine Gun
    _M151_187 = {187} -- [P] [27,65] [107459] 1/4 ton truck

    _LOGISTICS_COY_LEVEL_1_62_134 = {135} -- [C] [1009292] Logistics Company - Level 1 - 62

    _SUPPLY_TRUCKS_135 = {135} -- [P] [27,66] [106816] Supply Trucks (VP)

    -- hand-crafted org lists, if any, to follow

    --traceoff()

	CHINESE_COYS = {3,16,29,61}
	US_COYS = {98,107,116,125}
    US_SUPPLIES = {135}
    CHINESE_SUPPLIES = {202}

end

------------------------------------------------------------------------------------------------------------------------

function init_variables ()

    -- initialize values possibly varying through the course of the scenario
    -- called once only, in on_startup()

    -- embark/disembark points
    -- for example:
    -- _D303_VC_MAIN_FORCE_INF_BTN_2ND_RIFLE_COY_EMBARK_PT = random_index(3,5)

    -- target points
    -- for example:
    -- _MACV_GUNSHIPS_TARGET_PT = random_pick({1,2,3,4,5,6,7,8,12})

    -- others ...
    -- for example:
    -- NUMBER_VC_ATTACKS = 0
    -- _2ND_ARVN_MARINE_BTN_LEADERLESS = false
    -- NUMBER_US_AIRSTRIKES = air_support("a")
    -- BATTLE_PLAN_HMONG = dieroll(2)

end

------------------------------------------------------------------------------------------------------------------------

function show_briefing (side) -- DO NOT REMOVE

    -- player briefings

    if side == SIDE_A then

--[[
            memo("Side A Briefing", 
                   "SIDE B PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the VC Player, or Side B. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("SMEAC", 
                   "Battle of Highway 7\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "It is imperative that we secure Mamut and Highway 7 there for future operations. We are expecting resistance as we advance along the road.\n" .. 
                   "\n" .. 
                   "Friendly Forces:  You are in command of a dismounted infantry battalion, supported by some tanks, helicopters and artillery.\n" .. 
                   "\n" .. 
                   "Enemy Forces: Air reconnaissance reports a Chinese infantry unit operating further up the road.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the secure the towns along Highway 7.\n" ..
                   "Your Secondary Mission is to secure the villages on the flanks of the highway.\n" ..  
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Advance along Highway 7, securing the key Objectives as you go.\n" ..
                   "Once secured, ensure the flanks are secured against any probes.\n" ..
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Additional supplies are not expected.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\
",
                   side, side
                  )

    elseif side == SIDE_B then

--[[
            memo("Side B Briefing", 
                   "SIDE A PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the US Player, or Side A. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("Side B Briefing", 
                   "Battle of Highway 7\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "It is imperative that we secure Mamut and Highway 7 there for future operations. We are expecting resistance as we advance along the road.\n" ..
                   "\n" .. 
                   "Friendly Forces: You are in command of a dismounted infantry battalion, supported by some tanks, helicopters and artillery.\n" .. 
                   "\n" .. 
                   "Enemy Forces: Air reconnaissance reports an American infantry unit operating further down the road.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the secure the towns along Highway 7.\n" ..
                   "Your Secondary Mission is to secure the villages on the flanks of the highway.\n" ..  
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Advance along Highway 7, securing the key Objectives as you go.\n" ..
                   "Once secured, ensure the flanks are secured against any probes.\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Additional supplies are not expected.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    end

end

------------------------------------------------------------------------------------------------------------------------

function on_shutdown () -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------
    
function on_next_turn (turn) -- DO NOT REMOVE
    

    -- after first (in)direct fire, Side A loses (arty) supply each turn
    if SIDE_A_FIRED then
        inc_ammo_level(SIDE_A, -2)
    end
    if SIDE_A_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_A, -2)
    end

    -- after first (in)direct fire, Side B loses (arty) supply each turn
    if SIDE_B_FIRED then
        inc_ammo_level(SIDE_B, -2)
    end
    if SIDE_B_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_B, -2)
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_next_phase (turn, side) -- DO NOT REMOVE

    -- for testing purposes; note that these might override player selected options!
    -- by default, in normal game play, the player selected options apply;
    -- by default, in auto-test mode, FOW is OFF, all the time, for both sides
    if is_test_trial_play() and not is_qa_testing() then
        set_fow(side, 0) -- for current side, set FOW OFF
        set_fow(other_side(side), 1) -- for opposing side, set FOW ON
    end

    set_org_lists(turn, side)

    if turn == 1 then
        show_briefing(side)
    end

    battle_plan(turn, side)

--[[ commonly used, uncomment and adapt as necessary:
    -- every phase, adjust downward the NVA assault_attack_aggressiveness_effect bonus per their current loss rate
    adjust_adaptive_ai (sideof(NORTH_VIETNAM_NATION), NORTH_VIETNAM_NATION, "assault_attack_aggressiveness_effect", - math.floor(total_loss_rate(sideof(NORTH_VIETNAM_NATION))/2))
--]]

    if DEBUG then  -- where DEBUG is set in user.lua
        csee_check(turn, side)
    end

    if side == US_SIDE then
        -- US gains for securing HILL_93
        if owned(HILL_93, US_SIDE) then
            TURNS_US_HOLD_HILL_93 = (TURNS_US_HOLD_HILL_93 or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_HILL_93 " .. TURNS_US_HOLD_HILL_93)
            if TURNS_US_HOLD_HILL_93 == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 20)
                memo("US forces holds HILL_93 3", "For holding Hill 93 for 3 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HILL_93 == 5 then 
                inc_event_points(US_SIDE, 20)
                memo("US forces holds HILL_93 5", "For holding Hill 93 for 5 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HILL_93 == 7 then 
                inc_event_points(US_SIDE, 40)
                memo("US forces holds HILL_93 7", "For holding Hill 93 for 7 turns, the US side gains 40 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HILL_93 == 9 then 
                inc_event_points(US_SIDE, 60)
                memo("US forces holds HILL_93 9", "For holding Hill 93 for 9 turns, the US side gains 60 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HILL_93 == 11 then 
                inc_event_points(US_SIDE, 80)
                memo("US forces holds HILL_93 11", "For holding Hill 93 for 11 turns, the US side gains 80 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HILL_93 == 13 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds HILL_93 13", "For holding Hill 93 for 13 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_TAKE
        if owned(PHUM_TAKE, US_SIDE) then
            TURNS_US_HOLD_PHUM_TAKE = (TURNS_US_HOLD_PHUM_TAKE or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_TAKE " .. TURNS_US_HOLD_PHUM_TAKE)
            if TURNS_US_HOLD_PHUM_TAKE == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_TAKE 3", "For holding the town of Phum Take for 3 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_TAKE == 5 then 
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_TAKE 5", "For holding the town of Phum Take for 5 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_TAKE == 7 then 
                inc_event_points(US_SIDE, 40)
                memo("US forces holds PHUM_TAKE 7", "For holding the town of Phum Take for 7 turns, the US side gains 40 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_TAKE == 9 then 
                inc_event_points(US_SIDE, 60)
                memo("US forces holds PHUM_TAKE 9", "For holding the town of Phum Take for 9 turns, the US side gains 60 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_TAKE == 11 then 
                inc_event_points(US_SIDE, 80)
                memo("US forces holds PHUM_TAKE 11", "For holding the town of Phum Take for 11 turns, the US side gains 80 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_TAKE == 13 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_TAKE 13", "For holding the town of Phum Take for 13 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_CHNNGOR_KHANG_TBONG
        if owned(PHUM_CHNNGOR_KHANG_TBONG, US_SIDE) then
            TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG = (TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG " .. TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG)
            if TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 3", "For holding the town of Phum Chnngor Khang Tbong for 3 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 5 then 
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 5", "For holding the town of Phum Chnngor Khang Tbong for 5 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 7 then 
                inc_event_points(US_SIDE, 40)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 7", "For holding the town of Phum Chnngor Khang Tbong for 7 turns, the US side gains 40 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 9 then 
                inc_event_points(US_SIDE, 60)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 9", "For holding the town of Phum Chnngor Khang Tbong for 9 turns, the US side gains 60 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 11 then 
                inc_event_points(US_SIDE, 80)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 11", "For holding the town of Phum Chnngor Khang Tbong for 11 turns, the US side gains 80 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 13 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_CHNNGOR_KHANG_TBONG 13", "For holding the town of Phum Chnngor Khang Tbong for 13 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_CHNNGOR
        if owned(PHUM_CHNNGOR, US_SIDE) then
            TURNS_US_HOLD_PHUM_CHNNGOR = (TURNS_US_HOLD_PHUM_CHNNGOR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_CHNNGOR " .. TURNS_US_HOLD_PHUM_CHNNGOR)
            if TURNS_US_HOLD_PHUM_CHNNGOR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_CHNNGOR 3", "For holding the town of Phum Chnngor for 3 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR == 5 then 
                inc_event_points(US_SIDE, 20)
                memo("US forces holds PHUM_CHNNGOR 5", "For holding the town of Phum Chnngor for 5 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR == 7 then 
                inc_event_points(US_SIDE, 40)
                memo("US forces holds PHUM_CHNNGOR 7", "For holding the town of Phum Chnngor for 7 turns, the US side gains 40 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR == 9 then 
                inc_event_points(US_SIDE, 60)
                memo("US forces holds PHUM_CHNNGOR 9", "For holding the town of Phum Chnngor for 9 turns, the US side gains 60 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR == 11 then 
                inc_event_points(US_SIDE, 80)
                memo("US forces holds PHUM_CHNNGOR 11", "For holding the town of Phum Chnngor for 11 turns, the US side gains 80 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHNNGOR == 13 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_CHNNGOR 13", "For holding the town of Phum Chnngor for 13 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing KH_DAR
        if owned(KH_DAR, US_SIDE) then
            TURNS_US_HOLD_KH_DAR = (TURNS_US_HOLD_KH_DAR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_KH_DAR " .. TURNS_US_HOLD_KH_DAR)
            if TURNS_US_HOLD_KH_DAR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds KH_DAR 3", "For holding the town of Kh Dar for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_KH_DAR == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds KH_DAR 5", "For holding the town of Kh Dar for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_KH_DAR == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds KH_DAR 7", "For holding the town of Kh Dar for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_KH_DAR == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds KH_DAR 9", "For holding the town of Kh Dar for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_KH_DAR == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds KH_DAR 11", "For holding the town of Kh Dar for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_KH_DAR == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds KH_DAR 13", "For holding the town of Kh Dar for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing HIGHWAY_7_EAST
        if owned(HIGHWAY_7_EAST, US_SIDE) then
            TURNS_US_HOLD_HIGHWAY_7_EAST = (TURNS_US_HOLD_HIGHWAY_7_EAST or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_HIGHWAY_7_EAST " .. TURNS_US_HOLD_HIGHWAY_7_EAST)
            if TURNS_US_HOLD_HIGHWAY_7_EAST == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds HIGHWAY_7_EAST 3", "For holding the eastern portion of Highway 7 for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_EAST == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds HIGHWAY_7_EAST 5", "For holding the eastern portion of Highway 7 for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_EAST == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds HIGHWAY_7_EAST 7", "For holding the eastern portion of Highway 7 for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_EAST == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds HIGHWAY_7_EAST 9", "For holding the eastern portion of Highway 7 for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_EAST == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds HIGHWAY_7_EAST 11", "For holding the eastern portion of Highway 7 for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_EAST == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds HIGHWAY_7_EAST 13", "For holding the eastern portion of Highway 7 for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing HIGHWAY_7_WEST
        if owned(HIGHWAY_7_WEST, US_SIDE) then
            TURNS_US_HOLD_HIGHWAY_7_WEST = (TURNS_US_HOLD_HIGHWAY_7_WEST or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_HIGHWAY_7_WEST " .. TURNS_US_HOLD_HIGHWAY_7_WEST)
            if TURNS_US_HOLD_HIGHWAY_7_WEST == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds HIGHWAY_7_WEST 3", "For holding the western portion of Highway 7 for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_WEST == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds HIGHWAY_7_WEST 5", "For holding the western portion of Highway 7 for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_WEST == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds HIGHWAY_7_WEST 7", "For holding the western portion of Highway 7 for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_WEST == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds HIGHWAY_7_WEST 9", "For holding the western portion of Highway 7 for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_WEST == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds HIGHWAY_7_WEST 11", "For holding the western portion of Highway 7 for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_HIGHWAY_7_WEST == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds HIGHWAY_7_WEST 13", "For holding the western portion of Highway 7 for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_CHRAPEH
        if owned(PHUM_CHRAPEH, US_SIDE) then
            TURNS_US_HOLD_PHUM_CHRAPEH = (TURNS_US_HOLD_PHUM_CHRAPEH or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_CHRAPEH " .. TURNS_US_HOLD_PHUM_CHRAPEH)
            if TURNS_US_HOLD_PHUM_CHRAPEH == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_CHRAPEH 3", "For holding the town of Phum Chrapeh for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAPEH == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_CHRAPEH 5", "For holding the town of Phum Chrapeh for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAPEH == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds PHUM_CHRAPEH 7", "For holding the town of Phum Chrapeh for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAPEH == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_CHRAPEH 9", "For holding the town of Phum Chrapeh for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAPEH == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds PHUM_CHRAPEH 11", "For holding the town of Phum Chrapeh for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_CHRAPEH == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds PHUM_CHRAPEH 13", "For holding the town of Phum Chrapeh for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

        -- US gains for securing PHUM_SAMRAONG
        if owned(PHUM_SAMRAONG, US_SIDE) then
            TURNS_US_HOLD_PHUM_SAMRAONG = (TURNS_US_HOLD_PHUM_SAMRAONG or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_SAMRAONG " .. TURNS_US_HOLD_PHUM_SAMRAONG)
            if TURNS_US_HOLD_PHUM_SAMRAONG == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_SAMRAONG 3", "For holding the town of Phum Samraong for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_SAMRAONG == 5 then 
                inc_event_points(US_SIDE, 50)
                memo("US forces holds PHUM_SAMRAONG 5", "For holding the town of Phum Samraong for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_SAMRAONG == 7 then 
                inc_event_points(US_SIDE, 75)
                memo("US forces holds PHUM_SAMRAONG 7", "For holding the town of Phum Samraong for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_SAMRAONG == 9 then 
                inc_event_points(US_SIDE, 100)
                memo("US forces holds PHUM_SAMRAONG 9", "For holding the town of Phum Samraong for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_SAMRAONG == 11 then 
                inc_event_points(US_SIDE, 150)
                memo("US forces holds PHUM_SAMRAONG 11", "For holding the town of Phum Samraong for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
            elseif TURNS_US_HOLD_PHUM_SAMRAONG == 13 then 
                inc_event_points(US_SIDE, 200)
                memo("US forces holds PHUM_SAMRAONG 13", "For holding the town of Phum Samraong for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
            end
        end 

    end

    if side == CHINESE_SIDE then
        
        -- CHINESE gains for securing PHUM_SAMRAONG
        if owned(PHUM_SAMRAONG, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_SAMRAONG = (TURNS_CHINESE_HOLD_PHUM_SAMRAONG or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_SAMRAONG " .. TURNS_CHINESE_HOLD_PHUM_SAMRAONG)
            if TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_SAMRAONG 3", "For holding the town of Phum Samraong for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_SAMRAONG 5", "For holding the town of Phum Samraong for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds PHUM_SAMRAONG 7", "For holding the town of Phum Samraong for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_SAMRAONG 9", "For holding the town of Phum Samraong for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds PHUM_SAMRAONG 11", "For holding the town of Phum Samraong for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_SAMRAONG == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds PHUM_SAMRAONG 13", "For holding the town of Phum Samraong for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_CHRAPEH
        if owned(PHUM_CHRAPEH, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_CHRAPEH = (TURNS_CHINESE_HOLD_PHUM_CHRAPEH or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_CHRAPEH " .. TURNS_CHINESE_HOLD_PHUM_CHRAPEH)
            if TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_CHRAPEH 3", "For holding the town of Phum Chrapeh for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds PHUM_CHRAPEH 5", "For holding the town of Phum Chrapeh for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds PHUM_CHRAPEH 7", "For holding the town of Phum Chrapeh for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_CHRAPEH 9", "For holding the town of Phum Chrapeh for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds PHUM_CHRAPEH 11", "For holding the town of Phum Chrapeh for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHRAPEH == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds PHUM_CHRAPEH 13", "For holding the town of Phum Chrapeh for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing HIGHWAY_7_WEST
        if owned(HIGHWAY_7_WEST, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_HIGHWAY_7_WEST = (TURNS_CHINESE_HOLD_HIGHWAY_7_WEST or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_HIGHWAY_7_WEST " .. TURNS_CHINESE_HOLD_HIGHWAY_7_WEST)
            if TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds HIGHWAY_7_WEST 3", "For holding the western portion of Highway 7 for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds HIGHWAY_7_WEST 5", "For holding the western portion of Highway 7 for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds HIGHWAY_7_WEST 7", "For holding the western portion of Highway 7 for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds HIGHWAY_7_WEST 9", "For holding the western portion of Highway 7 for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds HIGHWAY_7_WEST 11", "For holding the western portion of Highway 7 for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_WEST == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds HIGHWAY_7_WEST 13", "For holding the western portion of Highway 7 for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing HIGHWAY_7_EAST
        if owned(HIGHWAY_7_EAST, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_HIGHWAY_7_EAST = (TURNS_CHINESE_HOLD_HIGHWAY_7_EAST or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_HIGHWAY_7_EAST " .. TURNS_CHINESE_HOLD_HIGHWAY_7_EAST)
            if TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds HIGHWAY_7_EAST 3", "For holding the eastern portion of Highway 7 for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds HIGHWAY_7_EAST 5", "For holding the eastern portion of Highway 7 for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds HIGHWAY_7_EAST 7", "For holding the eastern portion of Highway 7 for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds HIGHWAY_7_EAST 9", "For holding the eastern portion of Highway 7 for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds HIGHWAY_7_EAST 11", "For holding the eastern portion of Highway 7 for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HIGHWAY_7_EAST == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds HIGHWAY_7_EAST 13", "For holding the eastern portion of Highway 7 for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing KH_DAR
        if owned(KH_DAR, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_KH_DAR = (TURNS_CHINESE_HOLD_KH_DAR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_KH_DAR " .. TURNS_CHINESE_HOLD_KH_DAR)
            if TURNS_CHINESE_HOLD_KH_DAR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds KH_DAR 3", "For holding the town of Kh Dar for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_KH_DAR == 5 then 
                inc_event_points(CHINESE_SIDE, 50)
                memo("CHINESE forces holds KH_DAR 5", "For holding the town of Kh Dar for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_KH_DAR == 7 then 
                inc_event_points(CHINESE_SIDE, 75)
                memo("CHINESE forces holds KH_DAR 7", "For holding the town of Kh Dar for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_KH_DAR == 9 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds KH_DAR 9", "For holding the town of Kh Dar for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_KH_DAR == 11 then 
                inc_event_points(CHINESE_SIDE, 150)
                memo("CHINESE forces holds KH_DAR 11", "For holding the town of Kh Dar for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_KH_DAR == 13 then 
                inc_event_points(CHINESE_SIDE, 200)
                memo("CHINESE forces holds PHUM_CHNNGOR 13", "For holding the town of Kh Dar for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_CHNNGOR
        if owned(PHUM_CHNNGOR, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_CHNNGOR = (TURNS_CHINESE_HOLD_PHUM_CHNNGOR or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_CHNNGOR " .. TURNS_CHINESE_HOLD_PHUM_CHNNGOR)
            if TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_CHNNGOR 3", "For holding the town of Phum Chnngor for 3 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 5 then 
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_CHNNGOR 5", "For holding the town of Phum Chnngor for 5 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 7 then 
                inc_event_points(CHINESE_SIDE, 40)
                memo("CHINESE forces holds PHUM_CHNNGOR 7", "For holding the town of Phum Chnngor for 7 turns, the Chinese side gains 40 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 9 then 
                inc_event_points(CHINESE_SIDE, 60)
                memo("CHINESE forces holds PHUM_CHNNGOR 9", "For holding the town of Phum Chnngor for 9 turns, the Chinese side gains 60 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 11 then 
                inc_event_points(CHINESE_SIDE, 80)
                memo("CHINESE forces holds PHUM_CHNNGOR 11", "For holding the town of Phum Chnngor for 11 turns, the Chinese side gains 80 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR == 13 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_CHNNGOR 13", "For holding the town of Phum Chnngor for 13 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_CHNNGOR_KHANG_TBONG
        if owned(PHUM_CHNNGOR_KHANG_TBONG, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG = (TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG " .. TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG)
            if TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 3", "For holding the town of Phum Chnngor Khang Tbong for 3 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 5 then 
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 5", "For holding the town of Phum Chnngor Khang Tbong for 5 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 7 then 
                inc_event_points(CHINESE_SIDE, 40)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 7", "For holding the town of Phum Chnngor Khang Tbong for 7 turns, the Chinese side gains 40 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 9 then 
                inc_event_points(CHINESE_SIDE, 60)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 9", "For holding the town of Phum Chnngor Khang Tbong for 9 turns, the Chinese side gains 60 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 11 then 
                inc_event_points(CHINESE_SIDE, 80)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 11", "For holding the town of Phum Chnngor Khang Tbong for 11 turns, the Chinese side gains 80 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_CHNNGOR_KHANG_TBONG == 13 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_CHNNGOR_KHANG_TBONG 13", "For holding the town of Phum Chnngor Khang Tbong for 13 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing PHUM_TAKE
        if owned(PHUM_TAKE, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_PHUM_TAKE = (TURNS_CHINESE_HOLD_PHUM_TAKE or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_TAKE " .. TURNS_CHINESE_HOLD_PHUM_TAKE)
            if TURNS_CHINESE_HOLD_PHUM_TAKE == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_TAKE 3", "For holding the town of Phum Take for 3 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_TAKE == 5 then 
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds PHUM_TAKE 5", "For holding the town of Phum Take for 5 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_TAKE == 7 then 
                inc_event_points(CHINESE_SIDE, 40)
                memo("CHINESE forces holds PHUM_TAKE 7", "For holding the town of Phum Take for 7 turns, the Chinese side gains 40 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_TAKE == 9 then 
                inc_event_points(CHINESE_SIDE, 60)
                memo("CHINESE forces holds PHUM_TAKE 9", "For holding the town of Phum Take for 9 turns, the Chinese side gains 60 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_TAKE == 11 then 
                inc_event_points(CHINESE_SIDE, 80)
                memo("CHINESE forces holds PHUM_TAKE 11", "For holding the town of Phum Take for 11 turns, the Chinese side gains 80 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_PHUM_TAKE == 13 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds PHUM_TAKE 13", "For holding the town of Phum Take for 13 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end 

        -- CHINESE gains for securing HILL_93
        if owned(HILL_93, CHINESE_SIDE) then
            TURNS_CHINESE_HOLD_HILL_93 = (TURNS_CHINESE_HOLD_HILL_93 or 0) + 1
            log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_HILL_93 " .. TURNS_CHINESE_HOLD_HILL_93)
            if TURNS_CHINESE_HOLD_HILL_93 == 3 then -- not >= 3, to ensure one-time only EP gain
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds HILL_93 3", "For holding Hill 93 for 3 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HILL_93 == 5 then 
                inc_event_points(CHINESE_SIDE, 20)
                memo("CHINESE forces holds HILL_93 5", "For holding Hill 93 for 5 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HILL_93 == 7 then 
                inc_event_points(CHINESE_SIDE, 40)
                memo("CHINESE forces holds HILL_93 7", "For holding Hill 93 for 7 turns, the Chinese side gains 40 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HILL_93 == 9 then 
                inc_event_points(CHINESE_SIDE, 60)
                memo("CHINESE forces holds HILL_93 9", "For holding Hill 93 for 9 turns, the Chinese side gains 60 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HILL_93 == 11 then 
                inc_event_points(CHINESE_SIDE, 80)
                memo("CHINESE forces holds HILL_93 11", "For holding Hill 93 for 11 turns, the Chinese side gains 80 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            elseif TURNS_CHINESE_HOLD_HILL_93 == 13 then 
                inc_event_points(CHINESE_SIDE, 100)
                memo("CHINESE forces holds HILL_93 13", "For holding Hill 93 for 13 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
            end
        end
    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan (turn, side)

    -- UNLEASH is true if game launched with -U switch, or if Ctrl+Alt+U in game
    -- Ctrl+Alt+U is a toggle, so will set UNLEASH to false after an earlier Ctrl+Alt+U (setting UNLEASH to true)
    if UNLEASH then
        unleash(ALLA)
        unleash(ALLB)
        return
    end

    if side == SIDE_A and is_ai(side) then

        --traceon()
        battle_plan_a(turn, side)
        --traceoff()

    elseif side == SIDE_B and is_ai(side) then

        --traceon()
        battle_plan_b(turn, side)
        --traceoff()

    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_a (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side A units hold initially (or maybe use halt())
        hold(ALLA)
    end


--[[

    ----------------------------------------------------------------------------------------------------------------
    -- _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 -- PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP --
    ----------------------------------------------------------------------------------------------------------------

    -- _INF_BTN_HQ_2 -- Battalion HQ 49 (foot)
    do local units = _INF_BTN_HQ_2

    end

    -- _COMMANDER_200 -- Commander 2
    do local units = _COMMANDER_200

    end

    -- _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 -- 1st PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3

    end

    -- _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 -- 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16

    end

    -- _3RD_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_29 -- 3rd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _3RD_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_29

    end

    -- _TANK_COY_54_TYPE_59_70VP_46 -- Tank Company 54 - Type 59 - 70VP
    do local units = _TANK_COY_54_TYPE_59_70VP_46

    end

    -- _1ST_PLT_48 -- Type 59 Medium Tanks
    do local units = _1ST_PLT_48

    end

    -- _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 -- Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    do local units = _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51

    end
    -- _TYPE_85_122MM_HOWITZERS_52 -- Type 85 122mm Howitzers

    -- _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54 -- Anti-Aircraft Machinegun Company 65 - 36VP
    do local units = _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54

    end

    -- _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61 -- Armoured Reconnaissance Company 65 - Type 63 - 106VP
    do local units = _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61

    end

    -- _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70 -- PLA Motorized Engineer Company 65 - 132VP
    do local units = _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70

    end

    -- _1ST_PLT_71 -- PLA Engineer Platoon 65
    do local units = _1ST_PLT_71

    end

    -- _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80 -- PLA Helicopter Gunship Company - Alouette III Gunship - 60VP
    do local units = _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80

    end
    -- _ALOUETTE_III_GUNSHIP_81 -- SA-316 Alouette III Gunship
    -- _ALOUETTE_III_GUNSHIP_82 -- SA-316 Alouette III Gunship

    -- _PLA_SMG_INF_COY_65_54VP_90 -- PLA SMG Infantry Company 65 - 54VP
    do local units = _PLA_SMG_INF_COY_65_54VP_90

    end

    -- _1ST_PLT_91 -- PLA SMG Platoon 65
    do local units = _1ST_PLT_91

    end

    -- _LOGISTICS_COY_LEVEL_1_42 -- Logistics Company - Level 1
    do local units = _LOGISTICS_COY_LEVEL_1_42

    end

    -- _MOBILE_SUPPLY_202 -- Mobile Supply
    do local units = _MOBILE_SUPPLY_202

    end

    -----------------------------------------------------------------------------------------------------
    -- _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 -- Mechanized Infantry Battalion 67 - B - Vietnam - 0VP --
    -----------------------------------------------------------------------------------------------------

    -- _BTN_HQ_95 -- Battalion HQ (foot)
    do local units = _BTN_HQ_95

    end

    -- _COMMANDER_97 -- Commander 1
    do local units = _COMMANDER_97

    end

    -- _HQ_AND_SERVICE_COY_67_MECHANIZED_98 -- Headquarters and Service Company 67 - Mechanized
    do local units = _HQ_AND_SERVICE_COY_67_MECHANIZED_98

    end

    -- _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 -- A Mechanized Infantry Company 67 - B - Vietnam
    do local units = _A_MECHANIZED_INF_COY_67_B_VIETNAM_107

    end

    -- _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 -- B Mechanized Infantry Company 67 - B - Vietnam
    do local units = _B_MECHANIZED_INF_COY_67_B_VIETNAM_116

    end

    -- _C_MECHANIZED_INF_COY_67_B_VIETNAM_125 -- C Mechanized Infantry Company 67 - B - Vietnam
    do local units = _C_MECHANIZED_INF_COY_67_B_VIETNAM_125

    end

    -- _TANK_COY_66_M48A3_VIETNAM_0VP_143 -- Tank Company 66 - M48A3 - Vietnam - 0VP
    do local units = _TANK_COY_66_M48A3_VIETNAM_0VP_143

    end

    -- _M48_145 -- M48 Patton
    do local units = _M48_145

    end

    -- _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188 -- Assault Helicopter Company 67  - AH-1 - 0VP
    do local units = _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188

    end

    -- _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156 -- Motorized Engineer Company 66 - ROAD - 0VP
    do local units = _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156

    end

    -- _1ST_PLT_157 -- Engineer Platoon 66
    do local units = _1ST_PLT_157

    end

    -- _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 -- Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    do local units = _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183

    end
    -- _M114_155MM_184 -- M114 155mm Howitzers

    -- _LOGISTICS_COY_LEVEL_1_62_134 -- Logistics Company - Level 1 - 62
    do local units = _LOGISTICS_COY_LEVEL_1_62_134

    end

    -- _SUPPLY_TRUCKS_135 -- Supply Trucks (VP)
    do local units = _SUPPLY_TRUCKS_135

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_b (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side B units hold initially (or maybe use halt())
        hold(ALLB)
    end


--[[
    ----------------------------------------------------------------------------------------------------------------
    -- _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 -- PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP --
    ----------------------------------------------------------------------------------------------------------------

    -- _INF_BTN_HQ_2 -- Battalion HQ 49 (foot)
    do local units = _INF_BTN_HQ_2

    end

    -- _COMMANDER_200 -- Commander 2
    do local units = _COMMANDER_200

    end

    -- _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 -- 1st PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3

    end

    -- _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 -- 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16

    end

    -- _3RD_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_29 -- 3rd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _3RD_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_29

    end

    -- _TANK_COY_54_TYPE_59_70VP_46 -- Tank Company 54 - Type 59 - 70VP
    do local units = _TANK_COY_54_TYPE_59_70VP_46

    end

    -- _1ST_PLT_48 -- Type 59 Medium Tanks
    do local units = _1ST_PLT_48

    end

    -- _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 -- Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    do local units = _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51

    end
    -- _TYPE_85_122MM_HOWITZERS_52 -- Type 85 122mm Howitzers

    -- _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54 -- Anti-Aircraft Machinegun Company 65 - 36VP
    do local units = _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54

    end

    -- _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61 -- Armoured Reconnaissance Company 65 - Type 63 - 106VP
    do local units = _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61

    end

    -- _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70 -- PLA Motorized Engineer Company 65 - 132VP
    do local units = _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70

    end

    -- _1ST_PLT_71 -- PLA Engineer Platoon 65
    do local units = _1ST_PLT_71

    end

    -- _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80 -- PLA Helicopter Gunship Company - Alouette III Gunship - 60VP
    do local units = _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80

    end
    -- _ALOUETTE_III_GUNSHIP_81 -- SA-316 Alouette III Gunship
    -- _ALOUETTE_III_GUNSHIP_82 -- SA-316 Alouette III Gunship

    -- _PLA_SMG_INF_COY_65_54VP_90 -- PLA SMG Infantry Company 65 - 54VP
    do local units = _PLA_SMG_INF_COY_65_54VP_90

    end

    -- _1ST_PLT_91 -- PLA SMG Platoon 65
    do local units = _1ST_PLT_91

    end

    -- _LOGISTICS_COY_LEVEL_1_42 -- Logistics Company - Level 1
    do local units = _LOGISTICS_COY_LEVEL_1_42

    end

    -- _MOBILE_SUPPLY_202 -- Mobile Supply
    do local units = _MOBILE_SUPPLY_202

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function on_objective_capture (hc, value, values, side) -- DO NOT REMOVE


    if chance(22) then -- 22% chance for player receiving a shout
        if side == CHINESE_SIDE then
            message("Commendations", US_COMMENDATIONS[dieroll(#US_COMMENDATIONS)], side, side)
        else
            message("Commendations", CHINESE_COMMENDATIONS[dieroll(#CHINESE_COMMENDATIONS)], side, side)
        end
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_move (hc_from, hc_to, trackid) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE


    if side == SIDE_A then
        SIDE_A_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_FIRED = true
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_arty_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE


    if side == SIDE_A then
        SIDE_A_ARTY_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_ARTY_FIRED = true
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, attype) -- DO NOT REMOVE


    -- lose EPs for friendly fire arty or air attacks only
    if side == current_side() then -- side is the target side
        if attype == INDIRECTFIRE_COMBAT then
            inc_event_points(side, -5)
        elseif attype == AIRSTRIKE_COMBAT then
            inc_event_points(side, -10)
        end
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reduce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, loss, combat) -- DO NOT REMOVE 

--[[ commonly used, uncomment, adapt and repeat as necessary:
    if has_flag(counter_unit_other_flags(trackid), HELICOPTER) then
        inc_event_points(SIDE_B, 25*loss)
        note("Notice", "For destroying " .. loss .. " helicopter" .. (((loss > 1) and "s") or "") .. ", the VC side gains " .. 25*loss .. " EPs.", "ab", "ab")
    end
--]]

company_reduce_check(trackid, US_COYS, {"American","Chinese"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
company_reduce_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())


end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_kill (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE


    do local units = join({_BTN_HQ_95, _COMMANDER_97})
        local award = 25
         if member(trackid, units) then
             inc_event_points(CHINESE_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
         end
     end
 
     do local units = join({_1_1ST_WEAPONS_189, _2_1ST_WEAPONS_190})
         local award = 40
          if member(trackid, units) then
              inc_event_points(CHINESE_SIDE, award)
              note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
          end
      end
 
      do local units = _SUPPLY_TRUCKS_135
          local award = 70
          if member(trackid, units) then
              inc_event_points(CHINESE_SIDE, award)
              note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
          end
      end
 
     do local units = join({_INF_BTN_HQ_2, _COMMANDER_200})
         local award = 25
         if member(trackid, units) then
             inc_event_points(US_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
         end
     end
  
     do local units = join({_ALOUETTE_III_GUNSHIP_81, _ALOUETTE_III_GUNSHIP_82})
         local award = 40
         if member(trackid, units) then
             inc_event_points(US_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
         end
     end
   
     do local units = _MOBILE_SUPPLY_202
         local award = 70
         if member(trackid, units) then
             inc_event_points(US_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
         end
     end
  
     company_kill_check(trackid, US_COYS, {"American","Chinese"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
     
     company_kill_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
   
end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reinforce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  there are no hc hex coordinates for on_unit_release()

function on_unit_release (trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_remove (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  0 is superior (surviving) unit, 1 is subordinate (disappearing) unit

function on_unit_merge (hc, trackid0, pid0, name0, side0, nation0, oid0, orgname0, points0, strength0, HQ0, Leader0, trackid1, pid1, name1, side1, nation1, oid1, orgname1, points1, strength1, HQ1, Leader1) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_top (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_bottom (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_clockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_counterclockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_attack (hc, side, nation, attype) -- DO NOT REMOVE

    -- lose EPs for indirect fire or airstrike vs. inhabited hex (village, city, suburb), whether or not occupied by the enemy
    -- side is the firing side
    if -- is_building_hex(hc) or
       is_habitat_hex(hc) then
        if not_occupied(hc, other_side(side)) then
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -2)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -5)
            end
        else -- occupied
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -1)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -2)
            end
        end
    end

end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_assault (hc, side) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_air_attack (hc, pid, name, side, nation, points, strength) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_arty_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------ 

function on_mine_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_ied_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_vehicle_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_light_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_lay_mine_field (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_set_ied (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_barrier (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_damage (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_improve_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_entrench_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_lz (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_hex (hc) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------
