------------------------------------------------------------------------------------------------------------------------

-- XP_671231_PBEM_Set_A01.lua

-- Author: Jason Petho
-- Scripter: Jason Petho
-- Date: 20220213

------------------------------------------------------------------------------------------------------------------------

function on_startup () -- DO NOT REMOVE

    -- set/unset optional rules (effective in on_startup() only!)
    -- for example:
    -- set_option(OPTHISTORICALLZS)
    -- unset_option(OPTFACING)
    -- to specify every optional rule:
    -- set_options(OPTFIREMAP|OPTEXTFOW|OPTCOMMANDCTRL|OPTVISIBILITY)

    -- set/unset move tracking globally (maybe unset if performance lags)
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()
    init_variables ()

    set_org_lists()

end

------------------------------------------------------------------------------------------------------------------------

function on_resume () -- DO NOT REMOVE

    -- see on_startup()
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()

    set_org_lists(current_turn(), current_side())

end

------------------------------------------------------------------------------------------------------------------------

function init_constants ()

    -- initialize names and labels unvarying through the course of the scenario
    -- also define here lists with "holes" (index gaps) (such lists are not saved)
    -- called in on_startup(), and potentially again (and again) in any subsequent on_resume()

    -- Side "a" and "b" values with descriptive names
    SIDE_A = "a" -- _NATION ## (in user.lua)
    US_SIDE = SIDE_A
    SIDE_B = "b" -- _NATION ## (in user.lua)
    CHINESE_SIDE = SIDE_B

    OBJECTIVES = {}
    OBJECTIVES[1] = "62,45" -- 1-20[1/1] 0
    OBJECTIVES[2] = "66,51" -- 1-20[1/1] 0
    OBJECTIVES[3] = "68,44" -- 1-20[1/1] 0
    OBJECTIVES[4] = "69,46" -- 1-20[1/1] 0
    OBJECTIVES[5] = "70,44" -- 1-20[1/1] 0
    OBJECTIVES[6] = "70,50" -- 1-20[1/1] 0
    OBJECTIVES[7] = "71,45" -- 1-20[1/1] 0
    OBJECTIVES[8] = "71,49" -- 1-20[1/1] 0
    OBJECTIVES[9] = "72,42" -- 1-20[1/1] 0
    OBJECTIVES[10] = "72,50" -- 1-20[1/1] 0
    OBJECTIVES[11] = "74,49" -- 1-20[1/1] 0
    OBJECTIVES[12] = "75,53" -- 1-20[1/1] 0

    LANDING_ZONES = {}
    LANDING_ZONES[1] = "23,74"
    LANDING_ZONES[2] = "24,74"
    LANDING_ZONES[3] = "43,56"
    LANDING_ZONES[4] = "44,56"
    LANDING_ZONES[5] = "51,85"
    LANDING_ZONES[6] = "52,85"
    LANDING_ZONES[7] = "58,44"
    LANDING_ZONES[8] = "59,44"
    LANDING_ZONES[9] = "66,12"
    LANDING_ZONES[10] = "67,12"
    LANDING_ZONES[11] = "69,38"
    LANDING_ZONES[12] = "69,39"
    LANDING_ZONES[13] = "70,51"
    LANDING_ZONES[14] = "71,51"
    LANDING_ZONES[15] = "71,64"
    LANDING_ZONES[16] = "72,50"
    LANDING_ZONES[17] = "72,63"
    LANDING_ZONES[18] = "73,50"
    LANDING_ZONES[19] = "79,47"
    LANDING_ZONES[20] = "80,47"
    LANDING_ZONES[21] = "118,38"
    LANDING_ZONES[22] = "119,38"

    EMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- EMBARK_PTS[1] = "45,69"
    -- ...
    -- Side B
    -- ...
    -- EMBARK_PTS[x] = "20,48"

    DISEMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- DISEMBARK_PTS[1] = "41,69"
    -- ...
    -- Side B
    -- ...
    -- DISEMBARK_PTS[x] = "13,56"

    -- others ...
    NORTHWEST_OBJECTIVE = {OBJECTIVES[1]}
    MEMUT_TOWN = {OBJECTIVES[3],OBJECTIVES[4],OBJECTIVES[5],OBJECTIVES[7]}
    MEMUT_AIRFIELD = {OBJECTIVES[6],OBJECTIVES[8],OBJECTIVES[10],OBJECTIVES[11]}
    SOUTHWEST_OBJECTIVE = {OBJECTIVES[2]}
    PHUM_TRABEK = {OBJECTIVES[9]}
    HOSPITAL = {OBJECTIVES[12]}

    MEMUT_AIRFIELD_SUPPLY_AREA = hexes_within("72,50", NODIR, 2)

end

------------------------------------------------------------------------------------------------------------------------

function set_org_lists (turn, side)

    -- called in on_startup(), in every on_next_turn(), and potentially again (and again) in any subsequent on_resume()

    --traceon()

    turn = turn or 1
    side = side or "a"

    ALLA = counters_all(SIDE_A)
    ALLB = counters_all(SIDE_B)

    -- auto-generated org lists to follow; rename, resequence, regroup, and reorganize as necessary

    -- KEY:

    -- [P] Platoon
    -- [C] Company
    -- [B] Battalion
    -- [R] Regiment
    -- [G] Brigade
    -- [D] Division
    -- [K] Corps
    -- [A] Army

    _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 = {2,200,4,5,6,8,9,10,11,12,14,15,17,18,19,21,22,23,24,25,27,28,47,48,49,50,52,53,55,56,58,59,62,63,66,67,71,72,76,77,81,82,84,85,91,92,202,203,45,201} -- [B] [0012267] PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP

    _INF_BTN_HQ_2 = {2} -- [P] [68,12] [003009] Battalion HQ 49 (foot)

    _COMMANDER_200 = {200} -- [P] [68,12] [004002] Commander 2

    _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 = {4,5,6,8,9,10,11,12,14,15} -- [C] [0002301] 1st PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_4 = {4} -- [P] [67,17] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_5 = {5} -- [P] [67,16] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_6 = {6} -- [P] [67,15] [002024] PLA Mechanized Platoon 65 A
    _RPG_SECTION_8 = {8} -- [P] [67,14] [009015] Type 69 RPG AT Team
    _RPG_SECTION_9 = {9} -- [P] [68,13] [009015] Type 69 RPG AT Team
    _TYPE_86_APC_10 = {10} -- [P] [67,17] [007011] Type 86 IFV
    _TYPE_86_APC_11 = {11} -- [P] [67,16] [007011] Type 86 IFV
    _TYPE_86_APC_12 = {12} -- [P] [67,15] [007011] Type 86 IFV
    _TYPE_86_APC_14 = {14} -- [P] [67,14] [007011] Type 86 IFV
    _TYPE_86_APC_15 = {15} -- [P] [68,13] [007011] Type 86 IFV

    _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 = {17,18,19,21,22,23,24,25,27,28} -- [C] [0002301] 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    _1ST_PLT_17 = {17} -- [P] [117,39] [002024] PLA Mechanized Platoon 65 A
    _2ND_PLT_18 = {18} -- [P] [116,39] [002024] PLA Mechanized Platoon 65 A
    _3RD_PLT_19 = {19} -- [P] [117,39] [002024] PLA Mechanized Platoon 65 A
    _RPG_SECTION_21 = {21} -- [P] [118,37] [009015] Type 69 RPG AT Team
    _RPG_SECTION_22 = {22} -- [P] [117,38] [009015] Type 69 RPG AT Team
    _TYPE_86_APC_23 = {23} -- [P] [117,39] [007011] Type 86 IFV
    _TYPE_86_APC_24 = {24} -- [P] [116,39] [007011] Type 86 IFV
    _TYPE_86_APC_25 = {25} -- [P] [117,39] [007011] Type 86 IFV
    _TYPE_86_APC_27 = {27} -- [P] [117,38] [007011] Type 86 IFV
    _TYPE_86_APC_28 = {28} -- [P] [118,37] [007011] Type 86 IFV

    _TANK_COY_54_TYPE_59_70VP_46 = {47,48,49,50} -- [C] [0000208] Tank Company 54 - Type 59 - 70VP
    _HQ_PLT_47 = {47} -- [P] [67,16] [000024] Type 59 Medium Tanks
    _1ST_PLT_48 = {48} -- [P] [67,15] [000022] Type 59 Medium Tanks
    _2ND_PLT_49 = {49} -- [P] [67,14] [000022] Type 59 Medium Tanks
    _3RD_PLT_50 = {50} -- [P] [68,13] [000022] Type 59 Medium Tanks

    _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 = {52,53} -- [C] [0001259] Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    _TYPE_85_122MM_HOWITZERS_52 = {52} -- [P] [118,36] [001027] Type 85 122mm Howitzers
    _TRUCKS_53 = {53} -- [P] [118,36] [007034] Zil Trucks

    _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54 = {55,56,58,59} -- [C] [0008228] Anti-Aircraft Machinegun Company 65 - 36VP
    _1ST_BTY_55 = {55} -- [P] [117,38] [008019] PLA Heavy Machine Gun 65
    _2ND_BTY_56 = {56} -- [P] [68,11] [008019] PLA Heavy Machine Gun 65
    _TRUCKS_58 = {58} -- [P] [117,38] [007033] ZiS-5 Trucks
    _TRUCKS_59 = {59} -- [P] [68,11] [007033] ZiS-5 Trucks

    _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61 = {62,63,66,67} -- [C] [0006214] Armoured Reconnaissance Company 65 - Type 63 - 106VP
    _1ST_PLT_62 = {62} -- [P] [116,40] [002034] PLA Recon Platoon 55
    _2ND_PLT_63 = {63} -- [P] [116,39] [002034] PLA Recon Platoon 55
    _TYPE_63_66 = {66} -- [P] [116,40] [007008] Type 63C APC
    _TYPE_63_67 = {67} -- [P] [116,39] [007008] Type 63C APC

    _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70 = {71,72,76,77} -- [C] [0005210] PLA Motorized Engineer Company 65 - 132VP
    _1ST_PLT_71 = {71} -- [P] [68,11] [002069] PLA Engineer Platoon 65
    _2ND_PLT_72 = {72} -- [P] [118,37] [002069] PLA Engineer Platoon 65
    _UAZ452D_TRUCKS_76 = {76} -- [P] [68,11] [007040] Trucks
    _UAZ452D_TRUCKS_77 = {77} -- [P] [118,37] [007040] Trucks

    _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80 = {81,82} -- [C] [0007202] PLA Helicopter Gunship Company - Alouette III Gunship - 60VP
    _ALOUETTE_III_GUNSHIP_81 = {81} -- [P] [66,12] [006501] SA-316 Alouette III Gunship
    _ALOUETTE_III_GUNSHIP_82 = {82} -- [P] [67,12] [006501] SA-316 Alouette III Gunship

    _PLA_HELICOPTER_TRANSPORTATION_COY_Z5_360VP_83 = {84,85} -- [C] [0007201] PLA Helicopter Transportation Company - Z-5 - 360VP
    _Z5_84 = {84} -- [P] [119,38] [006502] Z-5 (Mi-4 Hound)
    _Z5_85 = {85} -- [P] [118,38] [006502] Z-5 (Mi-4 Hound)

    _PLA_SMG_INF_COY_65_54VP_90 = {91,92} -- [C] [0002290] PLA SMG Infantry Company 65 - 54VP
    _1ST_PLT_91 = {91} -- [P] [119,38] [002031] PLA SMG Platoon 65
    _2ND_PLT_92 = {92} -- [P] [118,38] [002031] PLA SMG Platoon 65

    _LOGISTICS_COY_LEVEL_1_42 = {202,203} -- [C] [0009210] Logistics Company - Level 1
    _MOBILE_SUPPLY_202 = {202} -- [P] [119,38] [003028] Mobile Supply
    _MOBILE_SUPPLY_203 = {203} -- [P] [67,12] [003028] Mobile Supply

    _TYPE_86_45 = {45} -- [P] [68,12] [007012] Type 86 IFV

    _JEEPS_201 = {201} -- [P] [68,12] [007048] Jeeps

    _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 = {95,96,97,99,100,101,102,108,109,110,111,112,113,114,115,117,118,119,120,121,122,123,124,144,145,146,189,190,193,157,158,160,161,164,165,166,167,168,169,184,185,135,136,140,141,142} -- [B] [1012315] Mechanized Infantry Battalion 67 - B - Vietnam - 0VP

    _BTN_HQ_95 = {95} -- [P] [33,61] [103011] Battalion HQ (foot)

    _TASK_FORCE_HQ_96 = {96} -- [P] [55,83] [103023] Task Force HQ (foot)

    _COMMANDER_97 = {97} -- [P] [33,61] [104001] Commander 1

    _HQ_AND_SERVICE_COY_67_MECHANIZED_98 = {99,100,101,102} -- [C] [1002389] Headquarters and Service Company 67 - Mechanized
    _1_RECONNAISSANCE_99 = {99} -- [P] [57,80] [102082] Reconnaissance 66
    _2_RECONNAISSANCE_100 = {100} -- [P] [56,79] [102082] Reconnaissance 66
    _M113A1_101 = {101} -- [P] [56,79] [107023] M113A1 APC
    _M113A1_102 = {102} -- [P] [57,80] [107023] M113A1 APC

    _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 = {108,109,110,111,112,113,114,115} -- [C] [1002391] A Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_108 = {108} -- [P] [56,82] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_109 = {109} -- [P] [54,82] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_110 = {110} -- [P] [56,81] [102047] Mechanized Rifle Platoon 67 B
    _1_WEAPONS_PLT_111 = {111} -- [P] [55,83] [109058] M113 106mm RR
    _2_WEAPONS_PLT_112 = {112} -- [P] [56,82] [101036] M125A1 Self-Propelled 81mm mortar
    _M113A1_113 = {113} -- [P] [56,82] [107021] M113A1 APC
    _M113A1_114 = {114} -- [P] [54,82] [107021] M113A1 APC
    _M113A1_115 = {115} -- [P] [56,81] [107021] M113A1 APC

    _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 = {117,118,119,120,121,122,123,124} -- [C] [1002391] B Mechanized Infantry Company 67 - B - Vietnam
    _1ST_PLT_117 = {117} -- [P] [31,62] [102047] Mechanized Rifle Platoon 67 B
    _2ND_PLT_118 = {118} -- [P] [32,61] [102047] Mechanized Rifle Platoon 67 B
    _3RD_PLT_119 = {119} -- [P] [35,60] [102047] Mechanized Rifle Platoon 67 B
    _1_WEAPONS_PLT_120 = {120} -- [P] [34,60] [109058] M113 106mm RR
    _2_WEAPONS_PLT_121 = {121} -- [P] [34,60] [101036] M125A1 Self-Propelled 81mm mortar
    _M113A1_122 = {122} -- [P] [31,62] [107021] M113A1 APC
    _M113A1_123 = {123} -- [P] [32,61] [107021] M113A1 APC
    _M113A1_124 = {124} -- [P] [35,60] [107021] M113A1 APC

    _TANK_COY_66_M48A3_VIETNAM_0VP_143 = {144,145,146} -- [C] [1000290] Tank Company 66 - M48A3 - Vietnam - 0VP
    _M48_144 = {144} -- [P] [35,60] [100074] M48 Roller
    _M48_145 = {145} -- [P] [32,61] [100021] M48 Patton
    _M48_146 = {146} -- [P] [31,62] [100021] M48 Patton

    _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188 = {189,190,193} -- [C] [1007409] Assault Helicopter Company 67  - AH-1 - 0VP
    _1_1ST_WEAPONS_189 = {189} -- [P] [23,74] [106549] AH-1G Early Cobra(2L2H)
    _2_1ST_WEAPONS_190 = {190} -- [P] [24,74] [106549] AH-1G Early Cobra(2L2H)
    _UH1D_193 = {193} -- [P] [24,74] [106521] UH-1D Huey

    _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156 = {157,158,160,161} -- [C] [1005255] Motorized Engineer Company 66 - ROAD - 0VP
    _1ST_PLT_157 = {157} -- [P] [30,62] [102091] Engineer Platoon 66
    _2ND_PLT_158 = {158} -- [P] [54,82] [102091] Engineer Platoon 66
    _ENGINEER_TRUCKS_160 = {160} -- [P] [30,62] [108807] Engineer Truck
    _ENGINEER_TRUCKS_161 = {161} -- [P] [54,82] [108807] Engineer Truck

    _ARMOURED_CAVALRY_TROOP_65_M113_ACAV_0VP_163 = {164,165,166,167,168,169} -- [C] [1006379] Armoured Cavalry Troop 65 - M113 ACAV - 0VP
    _M113A1_1ST_PLT_164 = {164} -- [P] [53,84] [107470] M113A1 APC
    _M113_ACAV_1ST_PLT_165 = {165} -- [P] [53,84] [107422] M113 ACAV
    _M113_ACAV_1ST_PLT_166 = {166} -- [P] [54,83] [107422] M113 ACAV
    _RIFLE_SQUAD_1ST_PLT_167 = {167} -- [P] [54,82] [102551] Reconnaissance 62
    _M113A1_1ST_PLT_168 = {168} -- [P] [54,82] [107470] M113A1 APC
    _M106_1ST_PLT_169 = {169} -- [P] [54,83] [101529] M106 Self-Propelled 4.2" mortar

    _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 = {184,185} -- [C] [1001323] Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    _M114_155MM_184 = {184} -- [P] [52,84] [101553] M114 155mm Howitzers
    _M35_185 = {185} -- [P] [52,84] [107436] 2 1/2 ton truck armed

    _LOGISTICS_COY_LEVEL_1_62_134 = {135,136} -- [C] [1009292] Logistics Company - Level 1 - 62
    _SUPPLY_TRUCKS_135 = {135} -- [P] [23,74] [106816] Supply Trucks (VP)
    _SUPPLY_TRUCKS_136 = {136} -- [P] [52,85] [106816] Supply Trucks (VP)

    _M577_140 = {140} -- [P] [33,61] [107072] M577 Command Vehicle

    _M577_141 = {141} -- [P] [55,83] [107072] M577 Command Vehicle

    _M151_142 = {142} -- [P] [33,61] [107065] 1/4 ton truck

    -- hand-crafted org lists, if any, to follow

    --traceoff()

	CHINESE_COYS = {3,16,50,61,70}
	US_COYS = {98,107,116,143,156,163}
    US_SUPPLIES = {135,136}
    CHINESE_SUPPLIES = {202,203}

end

------------------------------------------------------------------------------------------------------------------------

function init_variables ()

    -- initialize values possibly varying through the course of the scenario
    -- called once only, in on_startup()

    -- embark/disembark points
    -- for example:
    -- _D303_VC_MAIN_FORCE_INF_BTN_2ND_RIFLE_COY_EMBARK_PT = random_index(3,5)

    -- target points
    -- for example:
    -- _MACV_GUNSHIPS_TARGET_PT = random_pick({1,2,3,4,5,6,7,8,12})

    -- others ...
    -- for example:
    -- NUMBER_VC_ATTACKS = 0
    -- _2ND_ARVN_MARINE_BTN_LEADERLESS = false
    -- NUMBER_US_AIRSTRIKES = air_support("a")
    -- BATTLE_PLAN_HMONG = dieroll(2)

end

------------------------------------------------------------------------------------------------------------------------

function show_briefing (side) -- DO NOT REMOVE

    -- player briefings

    if side == SIDE_A then

--[[
            memo("Side A Briefing", 
                   "SIDE B PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the VC Player, or Side B. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("SMEAC", 
                   "Battle of Mamut\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "It is imperative that we secure Mamut and the airfield there for future operations. We are expecting resistance, but with the weather lately, reconnaissance has been minimal.\n" .. 
                   "\n" .. 
                   "Friendly Forces: You are in command of a mechanized task force, with helicopter support.\n" .. 
                   "\n" .. 
                   "Enemy Forces: A Chinese mechanized force was identified in the area.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the secure the town of Mamut and the Mamut Airield.\n" ..
                   "Your Secondary Mission is to secure the outlying areas.\n" ..  
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Advance to Mamut as quickly as possible to secure the area.\n" ..
                   "Once secure, send out battlegroups to capture the areas surrounding Mamut.\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Move the supplies as part of your armoured column to the Memut Airfield for extra supplies!\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    elseif side == SIDE_B then

--[[
            memo("Side B Briefing", 
                   "SIDE A PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the US Player, or Side A. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("Side B Briefing", 
                   "Battle of Mamut\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "It is imperative that we secure Mamut and the airfield there for future operations. We are expecting resistance, but with the weather lately, reconnaissance has been minimal.\n" .. 
                   "\n" .. 
                   "Friendly Forces: You are in command of a mechanized task force, with helicopter support.\n" .. 
                   "\n" .. 
                   "Enemy Forces: An American mechanized unit was detected in the area.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is the secure the town of Mamut and the Mamut Airield.\n" ..
                   "Your Secondary Mission is to secure the outlying areas.\n" .. 
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Advance to Mamut as quickly as possible to secure the area.\n" ..
                   "Once secure, send out battlegroups to capture the areas surrounding Mamut.\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Move the supplies as part of your armoured column to the Memut Airfield for extra supplies!\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    end

end

------------------------------------------------------------------------------------------------------------------------

function on_shutdown () -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------
    
function on_next_turn (turn) -- DO NOT REMOVE
    

    -- after first (in)direct fire, Side A loses (arty) supply each turn
    if SIDE_A_FIRED then
        inc_ammo_level(SIDE_A, -2)
    end
    if SIDE_A_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_A, -2)
    end

    -- after first (in)direct fire, Side B loses (arty) supply each turn
    if SIDE_B_FIRED then
        inc_ammo_level(SIDE_B, -2)
    end
    if SIDE_B_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_B, -2)
    end

    -- CHINESE gains for securing MEMUT_TOWN
	if owned(MEMUT_TOWN, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_MEMUT_TOWN = (TURNS_CHINESE_HOLD_MEMUT_TOWN or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_MEMUT_TOWN " .. TURNS_CHINESE_HOLD_MEMUT_TOWN)
		if TURNS_CHINESE_HOLD_MEMUT_TOWN == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds MEMUT_TOWN 3", "For holding the town of Memut for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_TOWN == 5 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds MEMUT_TOWN 5", "For holding the town of Memut for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_TOWN == 7 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds MEMUT_TOWN 7", "For holding the town of Memut for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_TOWN == 9 then 
			inc_event_points(CHINESE_SIDE, 100)
			memo("CHINESE forces holds MEMUT_TOWN 9", "For holding the town of Memut for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_TOWN == 11 then 
			inc_event_points(CHINESE_SIDE, 150)
			memo("CHINESE forces holds MEMUT_TOWN 11", "For holding the town of Memut for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_TOWN == 13 then 
			inc_event_points(CHINESE_SIDE, 200)
			memo("CHINESE forces holds MEMUT_TOWN 13", "For holding the town of Memut for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end
	end 

    -- CHINESE gains for securing MEMUT_AIRFIELD
	if owned(MEMUT_AIRFIELD, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_MEMUT_AIRFIELD = (TURNS_CHINESE_HOLD_MEMUT_AIRFIELD or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_MEMUT_AIRFIELD " .. TURNS_CHINESE_HOLD_MEMUT_AIRFIELD)
		if TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds MEMUT_AIRFIELD 3", "For holding the airfield of Memut for 3 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 5 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds MEMUT_AIRFIELD 5", "For holding the airfield of Memut for 5 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 7 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds MEMUT_AIRFIELD 7", "For holding the airfield of Memut for 7 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 9 then 
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds MEMUT_AIRFIELD 9", "For holding the airfield of Memut for 9 turns, the Chinese side gains 100 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 11 then 
			inc_event_points(CHINESE_SIDE, 150)
			memo("CHINESE forces holds MEMUT_AIRFIELD 11", "For holding the airfield of Memut for 11 turns, the Chinese side gains 150 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_MEMUT_AIRFIELD == 13 then 
			inc_event_points(CHINESE_SIDE, 200)
			memo("CHINESE forces holds MEMUT_AIRFIELD 13", "For holding the airfield of Memut for 13 turns, the Chinese side gains 200 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end
	end 

    -- CHINESE gains for securing NORTHWEST_OBJECTIVE
	if owned(NORTHWEST_OBJECTIVE, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE = (TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE " .. TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE)
		if TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 3", "For holding the northwest area for 3 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE == 5 then 
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 5", "For holding the northwest area for 5 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE == 7 then 
			inc_event_points(CHINESE_SIDE, 20)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 7", "For holding the northwest area for 7 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE== 9 then 
			inc_event_points(CHINESE_SIDE, 30)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 9", "For holding the northwest area for 9 turns, the Chinese side gains 30 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE == 11 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 11", "For holding the northwest area for 11 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_NORTHWEST_OBJECTIVE == 13 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds NORTHWEST_OBJECTIVE 11", "For holding the northwest area for 13 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end

	end 

    -- CHINESE gains for securing SOUTHWEST_OBJECTIVE
	if owned(SOUTHWEST_OBJECTIVE, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE = (TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE " .. TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE)
		if TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 3", "For holding the southwest area for 3 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 5 then 
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 5", "For holding the southwest area for 5 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 7 then 
			inc_event_points(CHINESE_SIDE, 20)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 7", "For holding the southwest area for 7 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 9 then 
			inc_event_points(CHINESE_SIDE, 30)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 9", "For holding the southwest area for 9 turns, the Chinese side gains 30 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 11 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 11", "For holding the southwest area for 11 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_SOUTHWEST_OBJECTIVE == 11 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds SOUTHWEST_OBJECTIVE 13", "For holding the southwest area for 13 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end
	end 

    -- CHINESE gains for securing PHUM_TRABEK
	if owned(PHUM_TRABEK, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_PHUM_TRABEK = (TURNS_CHINESE_HOLD_PHUM_TRABEK or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_PHUM_TRABEK " .. TURNS_CHINESE_HOLD_PHUM_TRABEK)
		if TURNS_CHINESE_HOLD_PHUM_TRABEK == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds PHUM_TRABEK 3", "For holding Phum Trabek for 3 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_PHUM_TRABEK == 5 then 
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds PHUM_TRABEK 5", "For holding Phum Trabek for 5 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_PHUM_TRABEK == 7 then 
			inc_event_points(CHINESE_SIDE, 20)
			memo("CHINESE forces holds PHUM_TRABEK 7", "For holding Phum Trabek for 7 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_PHUM_TRABEK == 9 then 
			inc_event_points(CHINESE_SIDE, 30)
			memo("CHINESE forces holds PHUM_TRABEK 9", "For holding Phum Trabek for 9 turns, the Chinese side gains 30 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_PHUM_TRABEK == 11 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds PHUM_TRABEK 11", "For holding Phum Trabek for 11 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_PHUM_TRABEK == 13 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds PHUM_TRABEK 13", "For holding Phum Trabek for 13 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end
	end 

    -- CHINESE gains for securing HOSPITAL
	if owned(HOSPITAL, CHINESE_SIDE) then
		TURNS_CHINESE_HOLD_HOSPITAL = (TURNS_CHINESE_HOLD_HOSPITAL or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CHINESE_HOLD_HOSPITAL " .. TURNS_CHINESE_HOLD_HOSPITAL)
		if TURNS_CHINESE_HOLD_HOSPITAL == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds HOSPITAL 3", "For holding the hospital for 3 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_HOSPITAL == 5 then 
			inc_event_points(CHINESE_SIDE, 10)
			memo("CHINESE forces holds HOSPITAL 5", "For holding the hospital for 5 turns, the Chinese side gains 10 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_HOSPITAL == 7 then 
			inc_event_points(CHINESE_SIDE, 20)
			memo("CHINESE forces holds HOSPITAL 7", "For holding the hospital for 7 turns, the Chinese side gains 20 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_HOSPITAL == 9 then 
			inc_event_points(CHINESE_SIDE, 30)
			memo("CHINESE forces holds HOSPITAL 9", "For holding the hospital for 9 turns, the Chinese side gains 30 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_HOSPITAL == 11 then 
			inc_event_points(CHINESE_SIDE, 50)
			memo("CHINESE forces holds HOSPITAL 11", "For holding the hospital for 11 turns, the Chinese side gains 50 EPs.", CHINESE_SIDE, CHINESE_SIDE)
        elseif TURNS_CHINESE_HOLD_HOSPITAL == 13 then 
			inc_event_points(CHINESE_SIDE, 75)
			memo("CHINESE forces holds HOSPITAL 13", "For holding the hospital for 13 turns, the Chinese side gains 75 EPs.", CHINESE_SIDE, CHINESE_SIDE)
		end
	end 



    -- US gains for securing MEMUT_TOWN
	if owned(MEMUT_TOWN, US_SIDE) then
		TURNS_US_HOLD_MEMUT_TOWN = (TURNS_US_HOLD_MEMUT_TOWN or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_MEMUT_TOWN " .. TURNS_US_HOLD_MEMUT_TOWN)
		if TURNS_US_HOLD_MEMUT_TOWN == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 50)
			memo("US forces holds MEMUT_TOWN 3", "For holding the town of Memut for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_TOWN == 5 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds MEMUT_TOWN 5", "For holding the town of Memut for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_TOWN == 7 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds MEMUT_TOWN 7", "For holding the town of Memut for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_TOWN == 9 then 
			inc_event_points(US_SIDE, 100)
			memo("US forces holds MEMUT_TOWN 9", "For holding the town of Memut for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_TOWN == 11 then 
			inc_event_points(US_SIDE, 150)
			memo("US forces holds MEMUT_TOWN 11", "For holding the town of Memut for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_TOWN == 13 then 
			inc_event_points(US_SIDE, 200)
			memo("US forces holds MEMUT_TOWN 13", "For holding the town of Memut for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
		end
	end 

    -- US gains for securing MEMUT_AIRFIELD
	if owned(MEMUT_AIRFIELD, US_SIDE) then
		TURNS_US_HOLD_MEMUT_AIRFIELD = (TURNS_US_HOLD_MEMUT_AIRFIELD or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_MEMUT_AIRFIELD " .. TURNS_US_HOLD_MEMUT_AIRFIELD)
		if TURNS_US_HOLD_MEMUT_AIRFIELD == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 50)
			memo("US forces holds MEMUT_AIRFIELD 3", "For holding the airfield of Memut for 3 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_AIRFIELD == 5 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds MEMUT_AIRFIELD 5", "For holding the airfield of Memut for 5 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_AIRFIELD == 7 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds MEMUT_AIRFIELD 7", "For holding the airfield of Memut for 7 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_AIRFIELD == 9 then 
			inc_event_points(US_SIDE, 10)
			memo("US forces holds MEMUT_AIRFIELD 9", "For holding the airfield of Memut for 9 turns, the US side gains 100 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_AIRFIELD == 11 then 
			inc_event_points(US_SIDE, 150)
			memo("US forces holds MEMUT_AIRFIELD 11", "For holding the airfield of Memut for 11 turns, the US side gains 150 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_MEMUT_AIRFIELD == 13 then 
			inc_event_points(US_SIDE, 200)
			memo("US forces holds MEMUT_AIRFIELD 13", "For holding the airfield of Memut for 13 turns, the US side gains 200 EPs.", US_SIDE, US_SIDE)
		end
	end 

    -- US gains for securing NORTHWEST_OBJECTIVE
	if owned(NORTHWEST_OBJECTIVE, US_SIDE) then
		TURNS_US_HOLD_NORTHWEST_OBJECTIVE = (TURNS_US_HOLD_NORTHWEST_OBJECTIVE or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_NORTHWEST_OBJECTIVE " .. TURNS_US_HOLD_NORTHWEST_OBJECTIVE)
		if TURNS_US_HOLD_NORTHWEST_OBJECTIVE == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 10)
			memo("US forces holds NORTHWEST_OBJECTIVE 3", "For holding the northwest area for 3 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_NORTHWEST_OBJECTIVE == 5 then 
			inc_event_points(US_SIDE, 10)
			memo("US forces holds NORTHWEST_OBJECTIVE 5", "For holding the northwest area for 5 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_NORTHWEST_OBJECTIVE == 7 then 
			inc_event_points(US_SIDE, 20)
			memo("US forces holds NORTHWEST_OBJECTIVE 7", "For holding the northwest area for 7 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_NORTHWEST_OBJECTIVE== 9 then 
			inc_event_points(US_SIDE, 30)
			memo("US forces holds NORTHWEST_OBJECTIVE 9", "For holding the northwest area for 9 turns, the US side gains 30 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_NORTHWEST_OBJECTIVE == 11 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds NORTHWEST_OBJECTIVE 11", "For holding the northwest area for 11 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_NORTHWEST_OBJECTIVE == 13 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds NORTHWEST_OBJECTIVE 11", "For holding the northwest area for 13 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
		end

	end 

    -- US gains for securing SOUTHWEST_OBJECTIVE
	if owned(SOUTHWEST_OBJECTIVE, US_SIDE) then
		TURNS_US_HOLD_SOUTHWEST_OBJECTIVE = (TURNS_US_HOLD_SOUTHWEST_OBJECTIVE or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_SOUTHWEST_OBJECTIVE " .. TURNS_US_HOLD_SOUTHWEST_OBJECTIVE)
		if TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 10)
			memo("US forces holds SOUTHWEST_OBJECTIVE 3", "For holding the southwest area for 3 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 5 then 
			inc_event_points(US_SIDE, 10)
			memo("US forces holds SOUTHWEST_OBJECTIVE 5", "For holding the southwest area for 5 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 7 then 
			inc_event_points(US_SIDE, 20)
			memo("US forces holds SOUTHWEST_OBJECTIVE 7", "For holding the southwest area for 7 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 9 then 
			inc_event_points(US_SIDE, 30)
			memo("US forces holds SOUTHWEST_OBJECTIVE 9", "For holding the southwest area for 9 turns, the US side gains 30 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 11 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds SOUTHWEST_OBJECTIVE 11", "For holding the southwest area for 11 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_SOUTHWEST_OBJECTIVE == 11 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds SOUTHWEST_OBJECTIVE 13", "For holding the southwest area for 13 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
		end
	end 

    -- US gains for securing PHUM_TRABEK
	if owned(PHUM_TRABEK, US_SIDE) then
		TURNS_US_HOLD_PHUM_TRABEK = (TURNS_US_HOLD_PHUM_TRABEK or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_PHUM_TRABEK " .. TURNS_US_HOLD_PHUM_TRABEK)
		if TURNS_US_HOLD_PHUM_TRABEK == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 10)
			memo("US forces holds PHUM_TRABEK 3", "For holding Phum Trabek for 3 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_PHUM_TRABEK == 5 then 
			inc_event_points(US_SIDE, 10)
			memo("US forces holds PHUM_TRABEK 5", "For holding Phum Trabek for 5 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_PHUM_TRABEK == 7 then 
			inc_event_points(US_SIDE, 20)
			memo("US forces holds PHUM_TRABEK 7", "For holding Phum Trabek for 7 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_PHUM_TRABEK == 9 then 
			inc_event_points(US_SIDE, 30)
			memo("US forces holds PHUM_TRABEK 9", "For holding Phum Trabek for 9 turns, the US side gains 30 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_PHUM_TRABEK == 11 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds PHUM_TRABEK 11", "For holding Phum Trabek for 11 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_PHUM_TRABEK == 13 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds PHUM_TRABEK 13", "For holding Phum Trabek for 13 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
		end
	end 

    -- US gains for securing HOSPITAL
	if owned(HOSPITAL, US_SIDE) then
		TURNS_US_HOLD_HOSPITAL = (TURNS_US_HOLD_HOSPITAL or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_US_HOLD_HOSPITAL " .. TURNS_US_HOLD_HOSPITAL)
		if TURNS_US_HOLD_HOSPITAL == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(US_SIDE, 10)
			memo("US forces holds HOSPITAL 3", "For holding the hospital for 3 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_HOSPITAL == 5 then 
			inc_event_points(US_SIDE, 10)
			memo("US forces holds HOSPITAL 5", "For holding the hospital for 5 turns, the US side gains 10 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_HOSPITAL == 7 then 
			inc_event_points(US_SIDE, 20)
			memo("US forces holds HOSPITAL 7", "For holding the hospital for 7 turns, the US side gains 20 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_HOSPITAL == 9 then 
			inc_event_points(US_SIDE, 30)
			memo("US forces holds HOSPITAL 9", "For holding the hospital for 9 turns, the US side gains 30 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_HOSPITAL == 11 then 
			inc_event_points(US_SIDE, 50)
			memo("US forces holds HOSPITAL 11", "For holding the hospital for 11 turns, the US side gains 50 EPs.", US_SIDE, US_SIDE)
        elseif TURNS_US_HOLD_HOSPITAL == 13 then 
			inc_event_points(US_SIDE, 75)
			memo("US forces holds HOSPITAL 13", "For holding the hospital for 13 turns, the US side gains 75 EPs.", US_SIDE, US_SIDE)
		end
	end 


end

------------------------------------------------------------------------------------------------------------------------

function on_next_phase (turn, side) -- DO NOT REMOVE

    -- for testing purposes; note that these might override player selected options!
    -- by default, in normal game play, the player selected options apply;
    -- by default, in auto-test mode, FOW is OFF, all the time, for both sides
    if is_test_trial_play() and not is_qa_testing() then
        set_fow(side, 0) -- for current side, set FOW OFF
        set_fow(other_side(side), 1) -- for opposing side, set FOW ON
    end

    set_org_lists(turn, side)

    if turn == 1 then
        show_briefing(side)
    end

    battle_plan(turn, side)

--[[ commonly used, uncomment and adapt as necessary:
    -- every phase, adjust downward the NVA assault_attack_aggressiveness_effect bonus per their current loss rate
    adjust_adaptive_ai (sideof(NORTH_VIETNAM_NATION), NORTH_VIETNAM_NATION, "assault_attack_aggressiveness_effect", - math.floor(total_loss_rate(sideof(NORTH_VIETNAM_NATION))/2))
--]]

    if DEBUG then  -- where DEBUG is set in user.lua
        csee_check(turn, side)
    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan (turn, side)

    -- UNLEASH is true if game launched with -U switch, or if Ctrl+Alt+U in game
    -- Ctrl+Alt+U is a toggle, so will set UNLEASH to false after an earlier Ctrl+Alt+U (setting UNLEASH to true)
    if UNLEASH then
        unleash(ALLA)
        unleash(ALLB)
        return
    end

    if side == SIDE_A and is_ai(side) then

        --traceon()
        battle_plan_a(turn, side)
        --traceoff()

    elseif side == SIDE_B and is_ai(side) then

        --traceon()
        battle_plan_b(turn, side)
        --traceoff()

    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_a (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side A units hold initially (or maybe use halt())
        hold(ALLA)
    end


--[[

    ----------------------------------------------------------------------------------------------------------------
    -- _PLA_MECHANIZED_INF_BTN_67_A_TYPE_86_530VP_1 -- PLA Mechanized Infantry Battalion 67 - A - Type 86 - 530VP --
    ----------------------------------------------------------------------------------------------------------------

    -- _INF_BTN_HQ_2 -- Battalion HQ 49 (foot)
    do local units = _INF_BTN_HQ_2

    end

    -- _COMMANDER_200 -- Commander 2
    do local units = _COMMANDER_200

    end

    -- _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3 -- 1st PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _1ST_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_3

    end

    -- _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16 -- 2nd PLA Mechanized Infantry Company 67 - A - Type 86
    do local units = _2ND_PLA_MECHANIZED_INF_COY_67_A_TYPE_86_16

    end

    -- _TANK_COY_54_TYPE_59_70VP_46 -- Tank Company 54 - Type 59 - 70VP
    do local units = _TANK_COY_54_TYPE_59_70VP_46

    end

    -- _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51 -- Motorized Artillery Battery - Type 85 122mm Howitzers - 54VP
    do local units = _MOTORIZED_ARTILLERY_BTY_TYPE_85_122MM_HOWITZERS_54VP_51

    end
    -- _TYPE_85_122MM_HOWITZERS_52 -- Type 85 122mm Howitzers

    -- _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54 -- Anti-Aircraft Machinegun Company 65 - 36VP
    do local units = _ANTIAIRCRAFT_MACHINEGUN_COY_65_36VP_54

    end

    -- _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61 -- Armoured Reconnaissance Company 65 - Type 63 - 106VP
    do local units = _ARMOURED_RECONNAISSANCE_COY_65_TYPE_63_106VP_61

    end

    -- _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70 -- PLA Motorized Engineer Company 65 - 132VP
    do local units = _PLA_MOTORIZED_ENGINEER_COY_65_132VP_70

    end

    -- _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80 -- PLA Helicopter Gunship Company - Alouette III Gunship - 60VP
    do local units = _PLA_HELICOPTER_GUNSHIP_COY_ALOUETTE_III_GUNSHIP_60VP_80

    end
    -- _ALOUETTE_III_GUNSHIP_81 -- SA-316 Alouette III Gunship
    -- _ALOUETTE_III_GUNSHIP_82 -- SA-316 Alouette III Gunship

    -- _PLA_HELICOPTER_TRANSPORTATION_COY_Z5_360VP_83 -- PLA Helicopter Transportation Company - Z-5 - 360VP
    do local units = _PLA_HELICOPTER_TRANSPORTATION_COY_Z5_360VP_83

    end

    -- _PLA_SMG_INF_COY_65_54VP_90 -- PLA SMG Infantry Company 65 - 54VP
    do local units = _PLA_SMG_INF_COY_65_54VP_90

    end

    -- _LOGISTICS_COY_LEVEL_1_42 -- Logistics Company - Level 1
    do local units = _LOGISTICS_COY_LEVEL_1_42

    end

    -- _TYPE_86_45 -- Type 86 IFV
    do local units = _TYPE_86_45

    end

    -- _JEEPS_201 -- Jeeps
    do local units = _JEEPS_201

    end

    -----------------------------------------------------------------------------------------------------
    -- _MECHANIZED_INF_BTN_67_B_VIETNAM_0VP_94 -- Mechanized Infantry Battalion 67 - B - Vietnam - 0VP --
    -----------------------------------------------------------------------------------------------------

    -- _BTN_HQ_95 -- Battalion HQ (foot)
    do local units = _BTN_HQ_95

    end

    -- _TASK_FORCE_HQ_96 -- Task Force HQ (foot)
    do local units = _TASK_FORCE_HQ_96

    end

    -- _COMMANDER_97 -- Commander 1
    do local units = _COMMANDER_97

    end

    -- _HQ_AND_SERVICE_COY_67_MECHANIZED_98 -- Headquarters and Service Company 67 - Mechanized
    do local units = _HQ_AND_SERVICE_COY_67_MECHANIZED_98

    end

    -- _A_MECHANIZED_INF_COY_67_B_VIETNAM_107 -- A Mechanized Infantry Company 67 - B - Vietnam
    do local units = _A_MECHANIZED_INF_COY_67_B_VIETNAM_107

    end
    -- _2_WEAPONS_PLT_112 -- M125A1 Self-Propelled 81mm mortar

    -- _B_MECHANIZED_INF_COY_67_B_VIETNAM_116 -- B Mechanized Infantry Company 67 - B - Vietnam
    do local units = _B_MECHANIZED_INF_COY_67_B_VIETNAM_116

    end
    -- _2_WEAPONS_PLT_121 -- M125A1 Self-Propelled 81mm mortar

    -- _TANK_COY_66_M48A3_VIETNAM_0VP_143 -- Tank Company 66 - M48A3 - Vietnam - 0VP
    do local units = _TANK_COY_66_M48A3_VIETNAM_0VP_143

    end

    -- _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188 -- Assault Helicopter Company 67  - AH-1 - 0VP
    do local units = _ASSAULT_HELICOPTER_COY_67_AH1_0VP_188

    end

    -- _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156 -- Motorized Engineer Company 66 - ROAD - 0VP
    do local units = _MOTORIZED_ENGINEER_COY_66_ROAD_0VP_156

    end

    -- _ARMOURED_CAVALRY_TROOP_65_M113_ACAV_0VP_163 -- Armoured Cavalry Troop 65 - M113 ACAV - 0VP
    do local units = _ARMOURED_CAVALRY_TROOP_65_M113_ACAV_0VP_163

    end
    -- _M106_1ST_PLT_169 -- M106 Self-Propelled 4.2" mortar

    -- _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183 -- Artillery Battery 65 - 6xM114/M35  - CAVALRY - 0VP
    do local units = _ARTILLERY_BTY_65_6XM114_M35_CAVALRY_0VP_183

    end
    -- _M114_155MM_184 -- M114 155mm Howitzers

    -- _LOGISTICS_COY_LEVEL_1_62_134 -- Logistics Company - Level 1 - 62
    do local units = _LOGISTICS_COY_LEVEL_1_62_134

    end

    -- _M577_140 -- M577 Command Vehicle
    do local units = _M577_140

    end

    -- _M577_141 -- M577 Command Vehicle
    do local units = _M577_141

    end

    -- _M151_142 -- 1/4 ton truck
    do local units = _M151_142

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_b (turn, side)


    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side B units hold initially (or maybe use halt())
        hold(ALLB)
    end


--[[

--]]

end

------------------------------------------------------------------------------------------------------------------------

function on_objective_capture (hc, value, values, side) -- DO NOT REMOVE


    if chance(25) then -- 25% chance for player receiving a shout
        if side == US_SIDE then
            message("Commendations", US_COMMENDATIONS[dieroll(#US_COMMENDATIONS)], side, side)
        else
            message("Commendations", CHINESE_COMMENDATIONS[dieroll(#CHINESE_COMMENDATIONS)], side, side)
        end
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_move (hc_from, hc_to, trackid) -- DO NOT REMOVE


    -- If supply unit arrives where instructed
    if member(hc_to,MEMUT_AIRFIELD_SUPPLY_AREA) and member(trackid,US_SUPPLIES) then
        if not SUPPLY_ARRIVES_AMERICAN then
            inc_ammo_level(US_SIDE,25)
            inc_arty_ammo_level(US_SIDE,20)
            inc_event_points("a", 100)
            message_once("AMERICAN Supply Arrival Progress Report",
                " Great job on getting your supplies to the Mamut Airfield! \n\n" ..
                " Your base Ammo level is increased by 25 and your Artillery Ammo level is increased by 20 and gained 100 Event Points! \n\n" ,
                "b", "b")
            SUPPLY_ARRIVES_AMERICAN = true 
        end 
    end 

    -- If supply unit arrives where instructed
    if member(hc_to,MEMUT_AIRFIELD_SUPPLY_AREA) and member(trackid,CHINESE_SUPPLIES) then
        if not SUPPLY_ARRIVES_CHINESE then
            inc_ammo_level(CHINESE_SIDE,25)
            inc_arty_ammo_level(CHINESE_SIDE,20)
            inc_event_points("b", 100)
            message_once("CHINESE Supply Arrival Progress Report",
                " Great job on getting your supplies to the Mamut Airfield! \n\n" ..
                " Your base Ammo level is increased by 25 and your Artillery Ammo level is increased by 20 and gained 100 Event Points! \n\n" ,
                "a", "a")
            SUPPLY_ARRIVES_CHINESE = true 
        end 
    end 


end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE

    if side == SIDE_A then
        SIDE_A_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_FIRED = true
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_arty_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE

    if side == SIDE_A then
        SIDE_A_ARTY_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_ARTY_FIRED = true
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, attype) -- DO NOT REMOVE

    -- lose EPs for friendly fire arty or air attacks only
    if side == current_side() then -- side is the target side
        if attype == INDIRECTFIRE_COMBAT then
            inc_event_points(side, -5)
        elseif attype == AIRSTRIKE_COMBAT then
            inc_event_points(side, -10)
        end
    end

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reduce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, loss, combat) -- DO NOT REMOVE 

--[[ commonly used, uncomment, adapt and repeat as necessary:
    if has_flag(counter_unit_other_flags(trackid), HELICOPTER) then
        inc_event_points(SIDE_B, 25*loss)
        note("Notice", "For destroying " .. loss .. " helicopter" .. (((loss > 1) and "s") or "") .. ", the VC side gains " .. 25*loss .. " EPs.", "ab", "ab")
    end
--]]


company_reduce_check(trackid, US_COYS, {"American","Chinese"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
company_reduce_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())



end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_kill (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE


    do local units = join({_BTN_HQ_95, _TASK_FORCE_HQ_96, _COMMANDER_97})
       local award = 25
        if member(trackid, units) then
            inc_event_points(CHINESE_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
        end
    end

    do local units = join({_1_1ST_WEAPONS_189, _2_1ST_WEAPONS_190, _UH1D_193})
        local award = 40
         if member(trackid, units) then
             inc_event_points(CHINESE_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
         end
     end

     do local units = join({_SUPPLY_TRUCKS_135, _SUPPLY_TRUCKS_136})
        local award = 70
         if member(trackid, units) then
             inc_event_points(CHINESE_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Chinese side gains " .. award .. " EPs.", CHINESE_SIDE, CHINESE_SIDE)
         end
     end

    do local units = join({_INF_BTN_HQ_2, _COMMANDER_200})
        local award = 25
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end
 
    do local units = join({_ALOUETTE_III_GUNSHIP_81, _ALOUETTE_III_GUNSHIP_82,_Z5_84,_Z5_85})
        local award = 40
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end
  
    do local units = join({_MOBILE_SUPPLY_202,_MOBILE_SUPPLY_203})
        local award = 70
        if member(trackid, units) then
            inc_event_points(US_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the American side gains " .. award .. " EPs.", US_SIDE, US_SIDE)
        end
    end
 
    company_kill_check(trackid, US_COYS, {"American","Chinese"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
    company_kill_check(trackid, CHINESE_COYS, {"Chinese","American"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
    

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reinforce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  there are no hc hex coordinates for on_unit_release()

function on_unit_release (trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_remove (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  0 is superior (surviving) unit, 1 is subordinate (disappearing) unit

function on_unit_merge (hc, trackid0, pid0, name0, side0, nation0, oid0, orgname0, points0, strength0, HQ0, Leader0, trackid1, pid1, name1, side1, nation1, oid1, orgname1, points1, strength1, HQ1, Leader1) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_top (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_bottom (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_clockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_counterclockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_attack (hc, side, nation, attype) -- DO NOT REMOVE


    -- lose EPs for indirect fire or airstrike vs. inhabited hex (village, city, suburb), whether or not occupied by the enemy
    -- side is the firing side
    if -- is_building_hex(hc) or
       is_habitat_hex(hc) then
        if not_occupied(hc, other_side(side)) then
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -2)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -5)
            end
        else -- occupied
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -1)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -2)
            end
        end
    end


end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_assault (hc, side) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_air_attack (hc, pid, name, side, nation, points, strength) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_arty_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------ 

function on_mine_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_ied_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_vehicle_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_light_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_lay_mine_field (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_set_ied (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_barrier (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_damage (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_improve_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_entrench_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_lz (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_hex (hc) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------
