------------------------------------------------------------------------------------------------------------------------

-- XP_671231_PBEM_Set_B01.lua

-- Author: Jason Petho
-- Scripter: Jsaon Petho
-- Date: 20220211

------------------------------------------------------------------------------------------------------------------------

function on_startup () -- DO NOT REMOVE

    -- set/unset optional rules (effective in on_startup() only!)
    -- for example:
    -- set_option(OPTHISTORICALLZS)
    -- unset_option(OPTFACING)
    -- to specify every optional rule:
    -- set_options(OPTFIREMAP|OPTEXTFOW|OPTCOMMANDCTRL|OPTVISIBILITY)

    -- set/unset move tracking globally (maybe unset if performance lags)
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()
    init_variables ()

    set_org_lists()

end

------------------------------------------------------------------------------------------------------------------------

function on_resume () -- DO NOT REMOVE

    -- see on_startup()
    -- set_move_tracking()
    -- unset_move_tracking()

    -- for deep debugging:
    --traceon()

    init_constants ()

    set_org_lists(current_turn(), current_side())

end

------------------------------------------------------------------------------------------------------------------------

function init_constants ()

    -- initialize names and labels unvarying through the course of the scenario
    -- also define here lists with "holes" (index gaps) (such lists are not saved)
    -- called in on_startup(), and potentially again (and again) in any subsequent on_resume()

    -- Side "a" and "b" values with descriptive names
    SIDE_A = "a" -- _NATION ## (in user.lua)
    CAMBODIAN_SIDE = SIDE_A
    SIDE_B = "b" -- _NATION ## (in user.lua)
    NVA_SIDE = SIDE_B

    OBJECTIVES = {}
    OBJECTIVES[1] = "46,55" -- 1-20[1/1] 21
    OBJECTIVES[2] = "51,44" -- 1-20[1/1] 21
    OBJECTIVES[3] = "51,51" -- 1-20[1/1] 21
    OBJECTIVES[4] = "53,68" -- 1-20[1/1] 21
    OBJECTIVES[5] = "55,49" -- 1-20[1/1] 49
    OBJECTIVES[6] = "60,58" -- 1-20[1/1] 21
    OBJECTIVES[7] = "62,45" -- 1-20[1/1] 49
    OBJECTIVES[8] = "63,42" -- 1-20[1/1] 49
    OBJECTIVES[9] = "64,71" -- 1-20[1/1] 21
    OBJECTIVES[10] = "66,52" -- 1-20[1/1] 49
    OBJECTIVES[11] = "67,32" -- 1-20[1/1] 49
    OBJECTIVES[12] = "68,32" -- 1-20[1/1] 49
    OBJECTIVES[13] = "68,44" -- 1-20[1/1] 49
    OBJECTIVES[14] = "69,45" -- 1-20[1/1] 49
    OBJECTIVES[15] = "69,46" -- 1-20[1/1] 49
    OBJECTIVES[16] = "69,50" -- 1-20[1/1] 49
    OBJECTIVES[17] = "70,44" -- 1-20[1/1] 49
    OBJECTIVES[18] = "70,45" -- 1-20[1/1] 49
    OBJECTIVES[19] = "70,56" -- 1-20[1/1] 49
    OBJECTIVES[20] = "71,45" -- 1-20[1/1] 49
    OBJECTIVES[21] = "71,49" -- 1-20[1/1] 49
    OBJECTIVES[22] = "71,51" -- 1-20[1/1] 49
    OBJECTIVES[23] = "72,42" -- 1-20[1/1] 49
    OBJECTIVES[24] = "72,49" -- 1-20[1/1] 49
    OBJECTIVES[25] = "72,50" -- 1-20[1/1] 49
    OBJECTIVES[26] = "74,49" -- 1-20[1/1] 49
    OBJECTIVES[27] = "75,53" -- 1-20[1/1] 49
    OBJECTIVES[28] = "82,41" -- 1-20[1/1] 49
    OBJECTIVES[29] = "86,54" -- 1-20[1/1] 49
    OBJECTIVES[30] = "88,44" -- 1-20[1/1] 49
    OBJECTIVES[31] = "91,48" -- 1-20[1/1] 49
    OBJECTIVES[32] = "92,45" -- 1-20[1/1] 49

    EMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- EMBARK_PTS[1] = "45,69"
    -- ...
    -- Side B
    -- ...
    -- EMBARK_PTS[x] = "20,48"

    DISEMBARK_PTS = {}
    -- and also, for example (indexing from 1 thru x):
    -- Side A
    -- DISEMBARK_PTS[1] = "41,69"
    -- ...
    -- Side B
    -- ...
    -- DISEMBARK_PTS[x] = "13,56"

    -- others ...

    NORTHWESTERN_VILLAGES = {OBJECTIVES[1],OBJECTIVES[2],OBJECTIVES[3]}
    SOUTHWESTERN_VILLAGES = {OBJECTIVES[4],OBJECTIVES[6],OBJECTIVES[9]}
    SOUTHERN_AREA = {OBJECTIVES[10],OBJECTIVES[19],OBJECTIVES[27]}
    WESTERN_VILLAGES = {OBJECTIVES[5],OBJECTIVES[7],OBJECTIVES[8]}
    MEMUT_TOWN = {OBJECTIVES[13],OBJECTIVES[14],OBJECTIVES[15],OBJECTIVES[17],OBJECTIVES[18],OBJECTIVES[20]}
    MEMUT_AIRFIELD = {OBJECTIVES[16],OBJECTIVES[21],OBJECTIVES[22],OBJECTIVES[24],OBJECTIVES[25],OBJECTIVES[26]}
    NORTHEASTERN_VILLAGES = {OBJECTIVES[28],OBJECTIVES[30],OBJECTIVES[31],OBJECTIVES[32]}
    MEMONG_AREA = {OBJECTIVES[11],OBJECTIVES[12]}

    MEMUT_AIRFIELD_SUPPLY_AREA = hexes_within("72,50", NODIR, 2)

end

------------------------------------------------------------------------------------------------------------------------

function set_org_lists (turn, side)

    -- called in on_startup(), in every on_next_turn(), and potentially again (and again) in any subsequent on_resume()

    --traceon()

    turn = turn or 1
    side = side or "a"

    ALLA = counters_all(SIDE_A)
    ALLB = counters_all(SIDE_B)

    -- auto-generated org lists to follow; rename, resequence, regroup, and reorganize as necessary

    -- KEY:

    -- [P] Platoon
    -- [C] Company
    -- [B] Battalion
    -- [R] Regiment
    -- [G] Brigade
    -- [D] Division
    -- [K] Corps
    -- [A] Army

    _BATAILLONS_BLINDEE_65_AMX13_75_0VP_1 = {2,126,4,5,6,7,8,9,11,12,13,14,15,16,18,19,20,21,22,23,41,42,43,45,132,47,48,49,51,56,59,53,54,37,127,38,129,39,131} -- [B] [4910202] Bataillons Blindee 65 - AMX-13/75 - 0VP

    _COMMANDEMENT_2 = {2} -- [P] [70,4] [493013] Battalion HQ (foot)

    _COMMANDER_126 = {126} -- [P] [70,3] [494002] Commander 2

    _1ST_1ST_ESCADRONS_DE_CHAR_64_AMX13_75_3 = {4,5,6,7,8,9} -- [C] [4900202] 1st/1st Escadrons de Char 64 - AMX-13/75
    _HQ_PLT_4 = {4} -- [P] [69,3] [490009] AMX-13/75 Light Tank
    _1ST_PLT_5 = {5} -- [P] [70,5] [490007] AMX-13/75 Light Tank
    _2ND_PLT_6 = {6} -- [P] [69,0] [490007] AMX-13/75 Light Tank
    _3RD_PLT_7 = {7} -- [P] [69,2] [490007] AMX-13/75 Light Tank
    _M20_ARMOURED_CAR_8 = {8} -- [P] [69,1] [496007] M20 Armoured Car
    _M20_ARMOURED_CAR_9 = {9} -- [P] [69,2] [496007] M20 Armoured Car

    _2ND_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_10 = {11,12,13,14,15,16} -- [C] [4902277] 2nd/1st Compagnie de Combat Blinde 60 - M3 - B
    _1ST_PLT_11 = {11} -- [P] [69,0] [492020] Rifle Platoon 60 B
    _2ND_PLT_12 = {12} -- [P] [70,5] [492020] Rifle Platoon 60 B
    _3RD_PLT_13 = {13} -- [P] [70,4] [492020] Rifle Platoon 60 B
    _M3_HALFTRACKS_14 = {14} -- [P] [69,0] [497059] M3 Halftracks
    _M3_HALFTRACKS_15 = {15} -- [P] [70,5] [497059] M3 Halftracks
    _M3_HALFTRACKS_16 = {16} -- [P] [70,4] [497059] M3 Halftracks

    _3RD_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_17 = {18,19,20,21,22,23} -- [C] [4902277] 3rd/1st Compagnie de Combat Blinde 60 - M3 - B
    _1ST_PLT_18 = {18} -- [P] [70,3] [492020] Rifle Platoon 60 B
    _2ND_PLT_19 = {19} -- [P] [70,3] [492020] Rifle Platoon 60 B
    _3RD_PLT_20 = {20} -- [P] [69,3] [492020] Rifle Platoon 60 B
    _M3_HALFTRACKS_21 = {21} -- [P] [70,3] [497059] M3 Halftracks
    _M3_HALFTRACKS_22 = {22} -- [P] [70,3] [497059] M3 Halftracks
    _M3_HALFTRACKS_23 = {23} -- [P] [69,3] [497059] M3 Halftracks

    _A_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_40 = {41,42,43,45,132} -- [C] [4902267] A/3rd Compagnie de Combat 60 - A/II - 0VP
    _1ST_PLT_41 = {41} -- [P] [70,45] [492019] Rifle Platoon 60 A
    _2ND_PLT_42 = {42} -- [P] [70,49] [492019] Rifle Platoon 60 A
    _3RD_PLT_43 = {43} -- [P] [69,51] [492019] Rifle Platoon 60 A
    _MMG_45 = {45} -- [P] [69,51] [492064] Medium Machine Gun
    _LAND_ROVERS_132 = {132} -- [P] [70,45] [497035] Land Rovers

    _B_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_46 = {47,48,49,51} -- [C] [4902267] B/3rd Compagnie de Combat 60 - A/II - 0VP
    _1ST_PLT_47 = {47} -- [P] [93,62] [492019] Rifle Platoon 60 A
    _2ND_PLT_48 = {48} -- [P] [94,62] [492019] Rifle Platoon 60 A
    _3RD_PLT_49 = {49} -- [P] [95,62] [492019] Rifle Platoon 60 A
    _MMG_51 = {51} -- [P] [94,62] [492064] Medium Machine Gun

    _COMPAGNIE_DE_GENIE_PORTES_60_0VP_55 = {56,59} -- [C] [4905206] Compagnie de Genie Portes 60 - 0VP
    _1ST_PLT_56 = {56} -- [P] [72,49] [492078] Engineer Platoon 60
    _TRUCKS_59 = {59} -- [P] [72,49] [497017] 2 1/2 ton truck

    _BATTERIE_DOBUSIERS_64_4_X_122MM_52 = {53,54} -- [C] [4901214] Batterie d'Obusiers 64 - 4 x 122mm
    _M30_122MM_HOWITZER_M1938_53 = {53} -- [P] [69,2] [491026] M-30 122mm Howitzer M1938
    _TRUCKS_54 = {54} -- [P] [69,2] [497016] 2 1/2 ton truck

    _DETACHEMENT_DU_TRAIN_LEVEL_1_36 = {37,127,38,129} -- [C] [4909214] Detachement du Train - Level 1
    _SUPPLY_CACHE_37 = {37} -- [P] [71,49] [498814] Supply Cache (VP)
    _SUPPLY_CACHE_127 = {127} -- [P] [69,1] [498816] Supply Cache (VP)
    _M35_38 = {38} -- [P] [71,49] [497015] 2 1/2 ton truck
    _M35_129 = {129} -- [P] [69,1] [497017] 2 1/2 ton truck

    _M3_HALFTRACKS_39 = {39} -- [P] [70,4] [497060] M3 Halftracks

    _LAND_ROVERS_131 = {131} -- [P] [70,3] [497037] Land Rovers

    _NVA_TASK_FORCE_67_AK_B_SVN_0VP_62 = {63,125,65,66,67,70,72,73,74,77,105,106,107,109,110,111,112,113,114,116,117,118,119,120,121,136,137,101,134,133} -- [B] [2112293] NVA Task Force 67 - AK - B - SVN - 0VP

    _TIEU_DOAN_HQ_63 = {63} -- [P] [9,65] [213010] NVA Battalion HQ (foot)

    _COMMANDER_125 = {125} -- [P] [9,65] [214002] NVA Commander 2

    _C1_D1_NVA_RIFLE_COY_67_AK_B_SVN_64 = {65,66,67,70} -- [C] [2102338] C1/D1 NVA Rifle Company 67 - AK - B - SVN
    _1ST_PLT_65 = {65} -- [P] [70,59] [212124] NVA Rifle Platoon 67 B
    _2ND_PLT_66 = {66} -- [P] [70,60] [212124] NVA Rifle Platoon 67 B
    _3RD_PLT_67 = {67} -- [P] [70,61] [212124] NVA Rifle Platoon 67 B
    _FIRE_SUPPORT_MMG_70 = {70} -- [P] [70,59] [212009] NVA Medium Machine Gun

    _C2_D1_NVA_RIFLE_COY_67_AK_B_SVN_71 = {72,73,74,77} -- [C] [2102338] C2/D1 NVA Rifle Company 67 - AK - B - SVN
    _1ST_PLT_72 = {72} -- [P] [51,51] [212124] NVA Rifle Platoon 67 B
    _2ND_PLT_73 = {73} -- [P] [49,52] [212124] NVA Rifle Platoon 67 B
    _3RD_PLT_74 = {74} -- [P] [50,51] [212124] NVA Rifle Platoon 67 B
    _FIRE_SUPPORT_MMG_77 = {77} -- [P] [51,51] [212009] NVA Medium Machine Gun

    _TANK_COY_64_PT76B_104 = {105,106,107} -- [C] [2100203] Tank Company 64 - PT-76B
    _1ST_COY_105 = {105} -- [P] [11,64] [210001] PT-76B
    _2ND_COY_106 = {106} -- [P] [10,64] [210001] PT-76B
    _3RD_COY_107 = {107} -- [P] [6,65] [210001] PT-76B

    _NVA_ARMOURED_RIFLE_COY_BTR50PK_B_108 = {109,110,111,112,113,114} -- [C] [2102299] NVA Armoured Rifle Company - BTR-50PK - B
    _1ST_PLT_109 = {109} -- [P] [9,65] [212001] NVA Rifle Platoon 63 B
    _2ND_PLT_110 = {110} -- [P] [11,64] [212001] NVA Rifle Platoon 63 B
    _3RD_PLT_111 = {111} -- [P] [10,64] [212001] NVA Rifle Platoon 63 B
    _BTR50PK_112 = {112} -- [P] [9,65] [217009] BTR-50PK
    _BTR50PK_113 = {113} -- [P] [11,64] [217010] BTR-50PK
    _BTR50PK_114 = {114} -- [P] [10,64] [217010] BTR-50PK

    _NVA_ARMOURED_RIFLE_COY_BTR152_B_115 = {116,117,118,119,120,121} -- [C] [2102298] NVA Armoured Rifle Company - BTR-152 - B
    _1ST_PLT_116 = {116} -- [P] [8,64] [212001] NVA Rifle Platoon 63 B
    _2ND_PLT_117 = {117} -- [P] [7,65] [212001] NVA Rifle Platoon 63 B
    _3RD_PLT_118 = {118} -- [P] [6,65] [212001] NVA Rifle Platoon 63 B
    _BTR152_AOP_119 = {119} -- [P] [8,64] [217006] BTR-152
    _BTR152_AOP_120 = {120} -- [P] [7,65] [217007] BTR-152
    _BTR152_AOP_121 = {121} -- [P] [6,65] [217007] BTR-152

    _MEDIUM_TRUCK_138 = {138} -- [P] [9,65] [217023] Medium Truck
    _SUPPLIES_100 = {100} -- [P] [9,65] [218811] Supplies


    _ARTILLERY_BTY_64_D30_122MM_TRACTORS_135 = {136,137} -- [C] [2101230] Artillery Battery 64 - D30 122mm/Tractors
    _D30_122MM_136 = {136} -- [P] [5,65] [211030] D30 122mm Howitzer
    _TRACTORS_137 = {137} -- [P] [5,65] [217024] ATS Prime Movers

    _DAC_CONG_101 = {101} -- [P] [6,65] [212002] NVA Sapper Platoon 63

    _MEDIUM_TRUCK_134 = {134} -- [P] [9,65] [217023] Medium Truck

    _LIGHT_TRUCK_133 = {133} -- [P] [9,65] [217018] Light Truck

    -- hand-crafted org lists, if any, to follow
	CAMBODIAN_COYS = {3,10,17,40,46}
	NVA_COYS = {115,104,71,64,115}

    --traceoff()

end

------------------------------------------------------------------------------------------------------------------------

function init_variables ()

    -- initialize values possibly varying through the course of the scenario
    -- called once only, in on_startup()

    -- embark/disembark points
    -- for example:
    -- _D303_VC_MAIN_FORCE_INF_BTN_2ND_RIFLE_COY_EMBARK_PT = random_index(3,5)

    -- target points
    -- for example:
    -- _MACV_GUNSHIPS_TARGET_PT = random_pick({1,2,3,4,5,6,7,8,12})

    -- others ...
    -- for example:
    -- NUMBER_VC_ATTACKS = 0
    -- _2ND_ARVN_MARINE_BTN_LEADERLESS = false
    -- NUMBER_US_AIRSTRIKES = air_support("a")
    -- BATTLE_PLAN_HMONG = dieroll(2)

end

------------------------------------------------------------------------------------------------------------------------

function show_briefing (side) -- DO NOT REMOVE

    -- player briefings

    if side == SIDE_A then

--[[
            memo("Side A Briefing", 
                   "SIDE B PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the VC Player, or Side B. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("SMEAC", 
                   "Battle of Memut\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "The Vietnamese have conducted a surprise attack in the Memut area! We must defend the town at all costs against the aggresors!\n" .. 
                   "\n" .. 
                   "Friendly Forces: You have an infantry screen in the town of Mamut with mechanized forces arriving from the north.\n" .. 
                   "\n" .. 
                   "Enemy Forces: Intelligence reports a reinforced battalion has crossed the border and is on the way to Memut.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is to keep Memut secured, including the airport area.\n" .. 
                   "Your Secondary Mission is to clear the villages along Route 7, as well as Phum Muk Kras and Phum Trapeang Reang along the north side of the highway.\n" .. 
                   "Your Tertiary Mission is to ensure the Vietnamese don't gain access to the hospital.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Use your infantry companies to protect Memut while you wait for reinforcements.\n" .. 
                   "Once arrived, counterattack along the highway and defeat the Vietnamese while protecting the areas described above.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Move the supplies as part of your armoured column to the Memut Airfield for extra supplies!\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    elseif side == SIDE_B then

--[[
            memo("Side B Briefing", 
                   "SIDE A PREFERENCE WARNING:\n" ..
                   "\n" ..
                   "\n" ..
                   "This scenario is intended to be played as the US Player, or Side A. Please restart the scenario.\n",
                   side, side
                  )
--]]
            report("Side B Briefing", 
                   "Battle of Memut\n" .. 
                   "NOTE: THIS IS DESIGNED FOR HEAD TO HEAD PLAY, THE AI IS NOT SCRIPTED. PLEASE FIND A HUMAN OPPONENT.\n" .. 
                   "\n" .. 
                   "SITUATION:\n" .. 
                   "\n" .. 
                   "It is time to teach the intolerable Cambodians a lesson! We will attack across the border and capture the town of Memut and the immediate surroundings.\n" ..
                   "\n" .. 
                   "Friendly Forces: You are in command of a reinforced infantry battalion, with armoured forces!\n" .. 
                   "\n" .. 
                   "Enemy Forces: Intelligence reports a smattering of Cambodian infantry in Mamut.\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "MISSION:\n" .. 
                   "\n" .. 
                   "Your Primary Mission is to capture Memut, the Memut airfield and hospital.\n" ..
                   "Your Secondary Mission is to secure the outlying village areas around Memut, denying the Cambodians any base of operations.\n" ..
                   "Your Tertiary Mission is to advance north and capture the town and local office at Memong.\n" ..
                   "\n" .. 
                   "\n" .. 
                   "EXECUTION:\n" .. 
                   "\n" .. 
                   "Use the infantry to advance towards Memut and secure the town in preparation for the arrival of your mobile forces.\n" ..
                   "Create combat groups to secure the outlying areas and advance to the north towards Memong.\n" ..
                   "\n" .. 
                   "\n" .. 
                   "POLITICAL:\n" ..
                   "\n" .. 
--                 "No special political considerations.\n" ..
                   "You lose Event Points for indirect firing or ordering airstrikes on inhabited hexes (village, city, suburb), whether or not occupied by the enemy.\n" ..
                   "\n" ..
                   "\n" .. 
                   "ADMIN:\n" .. 
                   "\n" .. 
                   "Supply levels are high at the beginning of the scenario, but expect them to taper off as the operation proceeds. Move the supplies as part of your armoured column to the Memut Airfield for extra supplies!\n" .. 
                   "\n" .. 
                   "\n" .. 
                   "COMMAND AND CONTROL:\n" .. 
                   "\n" .. 
                   "...\n" .. 
                   "\n" .. 
                   "Weather is expected to remain consistent during the course of the mission.\n",
                   side, side
                  )

    end

end

------------------------------------------------------------------------------------------------------------------------

function on_shutdown () -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------
    
function on_next_turn (turn) -- DO NOT REMOVE
    

    -- after first (in)direct fire, Side A loses (arty) supply each turn
    if SIDE_A_FIRED then
        inc_ammo_level(SIDE_A, -2)
    end
    if SIDE_A_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_A, -2)
    end

    -- after first (in)direct fire, Side B loses (arty) supply each turn
    if SIDE_B_FIRED then
        inc_ammo_level(SIDE_B, -2)
    end
    if SIDE_B_ARTY_FIRED then
        inc_arty_ammo_level(SIDE_B, -2)
    end

    -- Cambodian gains for securing NORTHWESTERN_VILLAGES
	if owned(NORTHWESTERN_VILLAGES, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES = (TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES " .. TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES)
		if TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 25)
			memo("CAMBODIAN forces holds NORTHWESTERN_VILLAGES 3", "For holding the northwestern villages for 3 turns, the Cambodian side gains 25 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 25)
			memo("CAMBODIAN forces holds NORTHWESTERN_VILLAGES 5", "For holding the northwestern villages for 5 turns, the Cambodian side gains 25 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds NORTHWESTERN_VILLAGES 7", "For holding the northwestern villages for 7 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 75)
			memo("CAMBODIAN forces holds NORTHWESTERN_VILLAGES 9", "For holding the northwestern villages for 9 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHWESTERN_VILLAGES == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 100)
			memo("CAMBODIAN forces holds NORTHWESTERN_VILLAGES 11", "For holding the northwestern villages for 11 turns, the Cambodian side gains 100 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing SOUTHWESTERN_VILLAGES
	if owned(SOUTHWESTERN_VILLAGES, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES = (TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES " .. TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES)
		if TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES == 3 then 
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds SOUTHWESTERN_VILLAGES 3", "For holding the southwestern villages for 3 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds SOUTHWESTERN_VILLAGES 5", "For holding the southwestern villages for 5 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 20)
			memo("CAMBODIAN forces holds SOUTHWESTERN_VILLAGES 7", "For holding the southwestern villages for 7 turns, the Cambodian side gains 20 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 30)
			memo("CAMBODIAN forces holds SOUTHWESTERN_VILLAGES 9", "For holding the southwestern villages for 9 turns, the Cambodian side gains 30 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHWESTERN_VILLAGES == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds SOUTHWESTERN_VILLAGES 11", "For holding the southwestern villages for 11 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing SOUTHERN_AREA
	if owned(SOUTHERN_AREA, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA = (TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA " .. TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA)
		if TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds SOUTHERN_AREA 3", "For holding the southwern area for 3 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds SOUTHERN_AREA 5", "For holding the southwern area for 5 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 20)
			memo("CAMBODIAN forces holds SOUTHERN_AREA 7", "For holding the southwern area for 7 turns, the Cambodian side gains 20 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 30)
			memo("CAMBODIAN forces holds SOUTHERN_AREA 9", "For holding the southwern area for 9 turns, the Cambodian side gains 30 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_SOUTHERN_AREA == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds SOUTHERN_AREA 11", "For holding the southwern area for 11 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing WESTERN_VILLAGES
	if owned(WESTERN_VILLAGES, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES = (TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES " .. TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES)
		if TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds WESTERN_VILLAGES 3", "For holding the western villages for 3 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds WESTERN_VILLAGES 5", "For holding the western villages for 5 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 75)
			memo("CAMBODIAN forces holds WESTERN_VILLAGES 7", "For holding the western villages for 7 turns, the Cambodian side gains 75 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 100)
			memo("CAMBODIAN forces holds WESTERN_VILLAGES 9", "For holding the western villages for 9 turns, the Cambodian side gains 100 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_WESTERN_VILLAGES == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 150)
			memo("CAMBODIAN forces holds WESTERN_VILLAGES 11", "For holding the western villages for 11 turns, the Cambodian side gains 150 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing MEMUT_TOWN
	if owned(MEMUT_TOWN, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_MEMUT_TOWN = (TURNS_CAMBODIAN_HOLD_MEMUT_TOWN or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_MEMUT_TOWN " .. TURNS_CAMBODIAN_HOLD_MEMUT_TOWN)
		if TURNS_CAMBODIAN_HOLD_MEMUT_TOWN == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds MEMUT_TOWN 3", "For holding the town of Memut for 3 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_TOWN == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds MEMUT_TOWN 5", "For holding the town of Memut for 5 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_TOWN == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 75)
			memo("CAMBODIAN forces holds MEMUT_TOWN 7", "For holding the town of Memut for 7 turns, the Cambodian side gains 75 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_TOWN == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 100)
			memo("CAMBODIAN forces holds MEMUT_TOWN 9", "For holding the town of Memut for 9 turns, the Cambodian side gains 100 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_TOWN == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 150)
			memo("CAMBODIAN forces holds MEMUT_TOWN 11", "For holding the town of Memut for 11 turns, the Cambodian side gains 150 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing MEMUT_AIRFIELD
	if owned(MEMUT_AIRFIELD, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD = (TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD " .. TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD)
		if TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 25)
			memo("CAMBODIAN forces holds MEMUT_AIRFIELD 3", "For holding the airfield of Memut for 3 turns, the Cambodian side gains 25 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 25)
			memo("CAMBODIAN forces holds MEMUT_AIRFIELD 5", "For holding the airfield of Memut for 5 turns, the Cambodian side gains 25 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds MEMUT_AIRFIELD 7", "For holding the airfield of Memut for 7 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 75)
			memo("CAMBODIAN forces holds MEMUT_AIRFIELD 9", "For holding the airfield of Memut for 9 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMUT_AIRFIELD == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 100)
			memo("CAMBODIAN forces holds MEMUT_AIRFIELD 11", "For holding the airfield of Memut for 11 turns, the Cambodian side gains 100 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing NORTHEASTERN_VILLAGES
	if owned(NORTHEASTERN_VILLAGES, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES = (TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES " .. TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES)
		if TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds NORTHEASTERN_VILLAGES 3", "For holding the northeastern villages for 3 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds NORTHEASTERN_VILLAGES 5", "For holding the northeastern villages for 5 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 20)
			memo("CAMBODIAN forces holds NORTHEASTERN_VILLAGES 7", "For holding the northeastern villages for 7 turns, the Cambodian side gains 20 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 30)
			memo("CAMBODIAN forces holds NORTHEASTERN_VILLAGES 9", "For holding the northeastern villages for 9 turns, the Cambodian side gains 30 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_NORTHEASTERN_VILLAGES == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds NORTHEASTERN_VILLAGES 11", "For holding the northeastern villages for 11 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 

    -- Cambodian gains for securing MEMONG_AREA
	if owned(MEMONG_AREA, CAMBODIAN_SIDE) then
		TURNS_CAMBODIAN_HOLD_MEMONG_AREA = (TURNS_CAMBODIAN_HOLD_MEMONG_AREA or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_CAMBODIAN_HOLD_MEMONG_AREA " .. TURNS_CAMBODIAN_HOLD_MEMONG_AREA)
		if TURNS_CAMBODIAN_HOLD_MEMONG_AREA == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds MEMONG_AREA 3", "For holding the Memong Area for 3 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMONG_AREA == 5 then 
			inc_event_points(CAMBODIAN_SIDE, 10)
			memo("CAMBODIAN forces holds MEMONG_AREA 5", "For holding the Memong Area for 5 turns, the Cambodian side gains 10 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMONG_AREA == 7 then 
			inc_event_points(CAMBODIAN_SIDE, 20)
			memo("CAMBODIAN forces holds MEMONG_AREA 7", "For holding the Memong Area for 7 turns, the Cambodian side gains 20 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMONG_AREA == 9 then 
			inc_event_points(CAMBODIAN_SIDE, 30)
			memo("CAMBODIAN forces holds MEMONG_AREA 9", "For holding the Memong Area for 9 turns, the Cambodian side gains 30 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        elseif TURNS_CAMBODIAN_HOLD_MEMONG_AREA == 11 then 
			inc_event_points(CAMBODIAN_SIDE, 50)
			memo("CAMBODIAN forces holds MEMONG_AREA 11", "For holding the Memong Area for 11 turns, the Cambodian side gains 50 EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
		end
	end 



    -- NVA gains for securing NORTHWESTERN_VILLAGES
	if owned(NORTHWESTERN_VILLAGES, NVA_SIDE) then
		TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES = (TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES " .. TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES)
		if TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 10)
			memo("NVA forces holds NORTHWESTERN_VILLAGES 3", "For holding the northwestern villages for 3 turns, the NVA side gains 10 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES == 5 then 
			inc_event_points(NVA_SIDE, 10)
			memo("NVA forces holds NORTHWESTERN_VILLAGES 5", "For holding the northwestern villages for 5 turns, the NVA side gains 10 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES == 7 then 
			inc_event_points(NVA_SIDE, 20)
			memo("NVA forces holds NORTHWESTERN_VILLAGES 7", "For holding the northwestern villages for 7 turns, the NVA side gains 20 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES == 9 then 
			inc_event_points(NVA_SIDE, 30)
			memo("NVA forces holds NORTHWESTERN_VILLAGES 9", "For holding the northwestern villages for 9 turns, the NVA side gains 30 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHWESTERN_VILLAGES == 11 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds NORTHWESTERN_VILLAGES 11", "For holding the northwestern villages for 11 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing SOUTHWESTERN_VILLAGES
	if owned(SOUTHWESTERN_VILLAGES, NVA_SIDE) then
		TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES = (TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES " .. TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES)
		if TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES == 3 then 
			inc_event_points(NVA_SIDE, 10)
			memo("NVA forces holds SOUTHWESTERN_VILLAGES 3", "For holding the southwestern villages for 3 turns, the NVA side gains 10 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES == 5 then 
			inc_event_points(NVA_SIDE, 10)
			memo("NVA forces holds SOUTHWESTERN_VILLAGES 5", "For holding the southwestern villages for 5 turns, the NVA side gains 10 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES == 7 then 
			inc_event_points(NVA_SIDE, 20)
			memo("NVA forces holds SOUTHWESTERN_VILLAGES 7", "For holding the southwestern villages for 7 turns, the NVA side gains 20 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES == 9 then 
			inc_event_points(NVA_SIDE, 30)
			memo("NVA forces holds SOUTHWESTERN_VILLAGES 9", "For holding the southwestern villages for 9 turns, the NVA side gains 30 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHWESTERN_VILLAGES == 11 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds SOUTHWESTERN_VILLAGES 11", "For holding the southwestern villages for 11 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing SOUTHERN_AREA
	if owned(SOUTHERN_AREA, NVA_SIDE) then
		TURNS_NVA_HOLD_SOUTHERN_AREA = (TURNS_NVA_HOLD_SOUTHERN_AREA or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_SOUTHERN_AREA " .. TURNS_NVA_HOLD_SOUTHERN_AREA)
		if TURNS_NVA_HOLD_SOUTHERN_AREA == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds SOUTHERN_AREA 3", "For holding the southwern area for 3 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHERN_AREA == 5 then 
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds SOUTHERN_AREA 5", "For holding the southwern area for 5 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHERN_AREA == 7 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds SOUTHERN_AREA 7", "For holding the southwern area for 7 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHERN_AREA == 9 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds SOUTHERN_AREA 9", "For holding the southwern area for 9 turns, the NVA side gains 75 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_SOUTHERN_AREA == 11 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds SOUTHERN_AREA 11", "For holding the southwern area for 11 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing WESTERN_VILLAGES
	if owned(WESTERN_VILLAGES, NVA_SIDE) then
		TURNS_NVA_HOLD_WESTERN_VILLAGES = (TURNS_NVA_HOLD_WESTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_WESTERN_VILLAGES " .. TURNS_NVA_HOLD_WESTERN_VILLAGES)
		if TURNS_NVA_HOLD_WESTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds WESTERN_VILLAGES 3", "For holding the western villages for 3 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_WESTERN_VILLAGES == 5 then 
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds WESTERN_VILLAGES 5", "For holding the western villages for 5 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_WESTERN_VILLAGES == 7 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds WESTERN_VILLAGES 7", "For holding the western villages for 7 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_WESTERN_VILLAGES == 9 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds WESTERN_VILLAGES 9", "For holding the western villages for 9 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_WESTERN_VILLAGES == 11 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds WESTERN_VILLAGES 11", "For holding the western villages for 11 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing MEMUT_TOWN
	if owned(MEMUT_TOWN, NVA_SIDE) then
		TURNS_NVA_HOLD_MEMUT_TOWN = (TURNS_NVA_HOLD_MEMUT_TOWN or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_MEMUT_TOWN " .. TURNS_NVA_HOLD_MEMUT_TOWN)
		if TURNS_NVA_HOLD_MEMUT_TOWN == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds MEMUT_TOWN 3", "For holding the town of Memut for 3 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_TOWN == 5 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds MEMUT_TOWN 5", "For holding the town of Memut for 5 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_TOWN == 7 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds MEMUT_TOWN 7", "For holding the town of Memut for 7 turns, the NVA side gains 75 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_TOWN == 9 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds MEMUT_TOWN 9", "For holding the town of Memut for 9 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_TOWN == 11 then 
			inc_event_points(NVA_SIDE, 150)
			memo("NVA forces holds MEMUT_TOWN 11", "For holding the town of Memut for 11 turns, the NVA side gains 150 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing MEMUT_AIRFIELD
	if owned(MEMUT_AIRFIELD, NVA_SIDE) then
		TURNS_NVA_HOLD_MEMUT_AIRFIELD = (TURNS_NVA_HOLD_MEMUT_AIRFIELD or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_MEMUT_AIRFIELD " .. TURNS_NVA_HOLD_MEMUT_AIRFIELD)
		if TURNS_NVA_HOLD_MEMUT_AIRFIELD == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds MEMUT_AIRFIELD 3", "For holding the airfield of Memut for 3 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_AIRFIELD == 5 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds MEMUT_AIRFIELD 5", "For holding the airfield of Memut for 5 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_AIRFIELD == 7 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds MEMUT_AIRFIELD 7", "For holding the airfield of Memut for 7 turns, the NVA side gains 75 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_AIRFIELD == 9 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds MEMUT_AIRFIELD 9", "For holding the airfield of Memut for 9 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMUT_AIRFIELD == 11 then 
			inc_event_points(NVA_SIDE, 150)
			memo("NVA forces holds MEMUT_AIRFIELD 11", "For holding the airfield of Memut for 11 turns, the NVA side gains 150 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing NORTHEASTERN_VILLAGES
	if owned(NORTHEASTERN_VILLAGES, NVA_SIDE) then
		TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES = (TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES " .. TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES)
		if TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds NORTHEASTERN_VILLAGES 3", "For holding the northeastern villages for 3 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES == 5 then 
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds NORTHEASTERN_VILLAGES 5", "For holding the northeastern villages for 5 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES == 7 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds NORTHEASTERN_VILLAGES 7", "For holding the northeastern villages for 7 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES == 9 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds NORTHEASTERN_VILLAGES 9", "For holding the northeastern villages for 9 turns, the NVA side gains 75 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_NORTHEASTERN_VILLAGES == 11 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds NORTHEASTERN_VILLAGES 11", "For holding the northeastern villages for 11 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 

    -- NVA gains for securing MEMONG_AREA
	if owned(MEMONG_AREA, NVA_SIDE) then
		TURNS_NVA_HOLD_MEMONG_AREA = (TURNS_NVA_HOLD_MEMONG_AREA or 0) + 1
	    log(LUALOG, LOG_DEBUG, "in on_next_turn(), Turn " .. turn .. ", TURNS_NVA_HOLD_MEMONG_AREA " .. TURNS_NVA_HOLD_MEMONG_AREA)
		if TURNS_NVA_HOLD_MEMONG_AREA == 3 then -- not >= 3, to ensure one-time only EP gain
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds MEMONG_AREA 3", "For holding the Memong Area for 3 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMONG_AREA == 5 then 
			inc_event_points(NVA_SIDE, 25)
			memo("NVA forces holds MEMONG_AREA 5", "For holding the Memong Area for 5 turns, the NVA side gains 25 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMONG_AREA == 7 then 
			inc_event_points(NVA_SIDE, 50)
			memo("NVA forces holds MEMONG_AREA 7", "For holding the Memong Area for 7 turns, the NVA side gains 50 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMONG_AREA == 9 then 
			inc_event_points(NVA_SIDE, 75)
			memo("NVA forces holds MEMONG_AREA 9", "For holding the Memong Area for 9 turns, the NVA side gains 75 EPs.", NVA_SIDE, NVA_SIDE)
        elseif TURNS_NVA_HOLD_MEMONG_AREA == 11 then 
			inc_event_points(NVA_SIDE, 100)
			memo("NVA forces holds MEMONG_AREA 11", "For holding the Memong Area for 11 turns, the NVA side gains 100 EPs.", NVA_SIDE, NVA_SIDE)
		end
	end 




end

------------------------------------------------------------------------------------------------------------------------

function on_next_phase (turn, side) -- DO NOT REMOVE

    -- for testing purposes; note that these might override player selected options!
    -- by default, in normal game play, the player selected options apply;
    -- by default, in auto-test mode, FOW is OFF, all the time, for both sides
    if is_test_trial_play() and not is_qa_testing() then
        set_fow(side, 0) -- for current side, set FOW OFF
        set_fow(other_side(side), 1) -- for opposing side, set FOW ON
    end

    set_org_lists(turn, side)

    if turn == 1 then
        show_briefing(side)
    end

    battle_plan(turn, side)


    -- every phase, adjust downward the NVA assault_attack_aggressiveness_effect bonus per their current loss rate
    adjust_adaptive_ai (sideof(NORTH_VIETNAM_NATION), NORTH_VIETNAM_NATION, "assault_attack_aggressiveness_effect", - math.floor(total_loss_rate(sideof(NORTH_VIETNAM_NATION))/2))


    if DEBUG then  -- where DEBUG is set in user.lua
        csee_check(turn, side)
    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan (turn, side)

    -- UNLEASH is true if game launched with -U switch, or if Ctrl+Alt+U in game
    -- Ctrl+Alt+U is a toggle, so will set UNLEASH to false after an earlier Ctrl+Alt+U (setting UNLEASH to true)
    if UNLEASH then
        unleash(ALLA)
        unleash(ALLB)
        return
    end

    if side == SIDE_A and is_ai(side) then

        --traceon()
        battle_plan_a(turn, side)
        --traceoff()

    elseif side == SIDE_B and is_ai(side) then

        --traceon()
        battle_plan_b(turn, side)
        --traceoff()

    end

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_a (turn, side)

--[[
    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side A units hold initially (or maybe use halt())
        hold(ALLA)
    end
--]]

--[[

    --------------------------------------------------------------------------------------
    -- _BATAILLONS_BLINDEE_65_AMX13_75_0VP_1 -- Bataillons Blindee 65 - AMX-13/75 - 0VP --
    --------------------------------------------------------------------------------------

    -- _COMMANDEMENT_2 -- Battalion HQ (foot)
    do local units = _COMMANDEMENT_2

    end

    -- _COMMANDER_126 -- Commander 2
    do local units = _COMMANDER_126

    end

    -- _1ST_1ST_ESCADRONS_DE_CHAR_64_AMX13_75_3 -- 1st/1st Escadrons de Char 64 - AMX-13/75
    do local units = _1ST_1ST_ESCADRONS_DE_CHAR_64_AMX13_75_3

    end

    -- _2ND_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_10 -- 2nd/1st Compagnie de Combat Blinde 60 - M3 - B
    do local units = _2ND_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_10

    end

    -- _3RD_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_17 -- 3rd/1st Compagnie de Combat Blinde 60 - M3 - B
    do local units = _3RD_1ST_COMPAGNIE_DE_COMBAT_BLINDE_60_M3_B_17

    end

    -- _A_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_40 -- A/3rd Compagnie de Combat 60 - A/II - 0VP
    do local units = _A_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_40

    end

    -- _B_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_46 -- B/3rd Compagnie de Combat 60 - A/II - 0VP
    do local units = _B_3RD_COMPAGNIE_DE_COMBAT_60_A_II_0VP_46

    end

    -- _COMPAGNIE_DE_GENIE_PORTES_60_0VP_55 -- Compagnie de Genie Portes 60 - 0VP
    do local units = _COMPAGNIE_DE_GENIE_PORTES_60_0VP_55

    end

    -- _BATTERIE_DOBUSIERS_64_4_X_122MM_52 -- Batterie d'Obusiers 64 - 4 x 122mm
    do local units = _BATTERIE_DOBUSIERS_64_4_X_122MM_52

    end
    -- _M30_122MM_HOWITZER_M1938_53 -- M-30 122mm Howitzer M1938

    -- _DETACHEMENT_DU_TRAIN_LEVEL_1_36 -- Detachement du Train - Level 1
    do local units = _DETACHEMENT_DU_TRAIN_LEVEL_1_36

    end

    -- _M3_HALFTRACKS_39 -- M3 Halftracks
    do local units = _M3_HALFTRACKS_39

    end

    -- _LAND_ROVERS_131 -- Land Rovers
    do local units = _LAND_ROVERS_131

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function battle_plan_b (turn, side)

--[[
    -- standard orders, uncomment as necessary:
    if turn == 1 then
        -- all Side B units hold initially (or maybe use halt())
        hold(ALLB)
    end
--]]

--[[

    ----------------------------------------------------------------------------------
    -- _NVA_TASK_FORCE_67_AK_B_SVN_0VP_62 -- NVA Task Force 67 - AK - B - SVN - 0VP --
    ----------------------------------------------------------------------------------

    -- _TIEU_DOAN_HQ_63 -- NVA Battalion HQ (foot)
    do local units = _TIEU_DOAN_HQ_63

    end

    -- _COMMANDER_125 -- NVA Commander 2
    do local units = _COMMANDER_125

    end

    -- _C1_D1_NVA_RIFLE_COY_67_AK_B_SVN_64 -- C1/D1 NVA Rifle Company 67 - AK - B - SVN
    do local units = _C1_D1_NVA_RIFLE_COY_67_AK_B_SVN_64

    end

    -- _C2_D1_NVA_RIFLE_COY_67_AK_B_SVN_71 -- C2/D1 NVA Rifle Company 67 - AK - B - SVN
    do local units = _C2_D1_NVA_RIFLE_COY_67_AK_B_SVN_71

    end

    -- _TANK_COY_64_PT76B_104 -- Tank Company 64 - PT-76B
    do local units = _TANK_COY_64_PT76B_104

    end

    -- _NVA_ARMOURED_RIFLE_COY_BTR50PK_B_108 -- NVA Armoured Rifle Company - BTR-50PK - B
    do local units = _NVA_ARMOURED_RIFLE_COY_BTR50PK_B_108

    end

    -- _NVA_ARMOURED_RIFLE_COY_BTR152_B_115 -- NVA Armoured Rifle Company - BTR-152 - B
    do local units = _NVA_ARMOURED_RIFLE_COY_BTR152_B_115

    end

    -- _ARTILLERY_BTY_64_D30_122MM_TRACTORS_135 -- Artillery Battery 64 - D30 122mm/Tractors
    do local units = _ARTILLERY_BTY_64_D30_122MM_TRACTORS_135

    end
    -- _D30_122MM_136 -- D30 122mm Howitzer

    -- _DAC_CONG_101 -- NVA Sapper Platoon 63
    do local units = _DAC_CONG_101

    end

    -- _MEDIUM_TRUCK_134 -- Medium Truck
    do local units = _MEDIUM_TRUCK_134

    end

    -- _LIGHT_TRUCK_133 -- Light Truck
    do local units = _LIGHT_TRUCK_133

    end

--]]

end

------------------------------------------------------------------------------------------------------------------------

function on_objective_capture (hc, value, values, side) -- DO NOT REMOVE


    if chance(25) then -- 25% chance for player receiving a shout
        if side == NVA_SIDE then
            message("Commendations", NVA_COMMENDATIONS[dieroll(#NVA_COMMENDATIONS)], side, side)
        else
            message("Commendations", CAMBODIAN_COMMENDATIONS[dieroll(#CAMBODIAN_COMMENDATIONS)], side, side)
        end
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_move (hc_from, hc_to, trackid) -- DO NOT REMOVE

    -- If supply unit arrives where instructed
    if member(hc_to,MEMUT_AIRFIELD_SUPPLY_AREA) and (trackid == 127) then
        if not SUPPLY_ARRIVES_VIETNAMESE then
            inc_ammo_level(NVA_SIDE,25)
            inc_arty_ammo_level(NVA_SIDE,20)
            inc_event_points("b", 100)
            message_once("VIETNAMESE Supply Arrival Progress Report",
                " Great job on getting your supplies to the Mamut Airfield! \n\n" ..
                " Your base Ammo level is increased by 25 and your Artillery Ammo level is increased by 20 and gained 100 Event Points! \n\n" ,
                "b", "b")
            SUPPLY_ARRIVES_VIETNAMESE = true 
        end 
    end 

    -- If supply unit arrives where instructed
    if member(hc_to,MEMUT_AIRFIELD_SUPPLY_AREA) and (trackid == 127) then
        if not SUPPLY_ARRIVES_CAMBODIAN then
            inc_ammo_level(CAMBODIAN_SIDE,25)
            inc_arty_ammo_level(CAMBODIAN_SIDE,20)
            inc_event_points("a", 100)
            message_once("CAMBODIAN Supply Arrival Progress Report",
                " Great job on getting your supplies to the Mamut Airfield! \n\n" ..
                " Your base Ammo level is increased by 25 and your Artillery Ammo level is increased by 20 and gained 100 Event Points! \n\n" ,
                "a", "a")
            SUPPLY_ARRIVES_CAMBODIAN = true 
        end 
    end 

end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE


    if side == SIDE_A then
        SIDE_A_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_FIRED = true
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_arty_fire (hc, trackid, pid, name, side, nation, oid, orgname, strength) -- DO NOT REMOVE


    if side == SIDE_A then
        SIDE_A_ARTY_FIRED = true
    elseif side == SIDE_B then
        SIDE_B_ARTY_FIRED = true
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, attype) -- DO NOT REMOVE


    -- lose EPs for friendly fire arty or air attacks only
    if side == current_side() then -- side is the target side
        if attype == INDIRECTFIRE_COMBAT then
            inc_event_points(side, -5)
        elseif attype == AIRSTRIKE_COMBAT then
            inc_event_points(side, -10)
        end
    end


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reduce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader, loss, combat) -- DO NOT REMOVE 

--[[ commonly used, uncomment, adapt and repeat as necessary:
    if has_flag(counter_unit_other_flags(trackid), HELICOPTER) then
        inc_event_points(SIDE_B, 25*loss)
        note("Notice", "For destroying " .. loss .. " helicopter" .. (((loss > 1) and "s") or "") .. ", the VC side gains " .. 25*loss .. " EPs.", "ab", "ab")
    end
--]]

company_reduce_check(trackid, CAMBODIAN_COYS, {"Cambodian","Vietnamese"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())
    
company_reduce_check(trackid, NVA_COYS, {"Vietnamese","Cambodian"}, {0,100}, {{NONATION},{NONATION}}, {0,0}, 50, both_sides(), both_sides())


end 

------------------------------------------------------------------------------------------------------------------------

function on_unit_kill (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE


    do local units = join({_COMMANDEMENT_2, _COMMANDER_126})
        local award = 30
        if member(trackid, units) then
            inc_event_points(NVA_SIDE, award)
            note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Vietnamese side gains " .. award .. " EPs.", NVA_SIDE, NVA_SIDE)
        end
    end

    do local units = join({_SUPPLY_CACHE_127, _SUPPLY_CACHE_37})
        local award = 50
        if member(trackid, units) then
             inc_event_points(NVA_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Vietnamese side gains " .. award .. " EPs.", NVA_SIDE, NVA_SIDE)
        end
    end

    do local units = join({_TIEU_DOAN_HQ_63, _COMMANDER_125})
        local award = 30
        if member(trackid, units) then
             inc_event_points(CAMBODIAN_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Cambodian side gains " .. award .. " EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        end
    end
  
    do local units = _SUPPLIES_100
        local award = 100
        if member(trackid, units) then
             inc_event_points(CAMBODIAN_SIDE, award)
             note("Notice", "For destroying the " .. counter_name(trackid) .. ", the Cambodian side gains " .. award .. " EPs.", CAMBODIAN_SIDE, CAMBODIAN_SIDE)
        end
    end
     
company_kill_check(trackid, CAMBODIAN_COYS, {"Cambodian","Vietnamese"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, both_sides(), both_sides())

company_kill_check(trackid, NVA_COYS, {"Vietnamese","Cambodian"}, {0,200}, {{NONATION},{NONATION}}, {0,0}, both_sides(), both_sides())

end

------------------------------------------------------------------------------------------------------------------------

function on_unit_reinforce (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  there are no hc hex coordinates for on_unit_release()

function on_unit_release (trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_remove (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

-- NOTE:  0 is superior (surviving) unit, 1 is subordinate (disappearing) unit

function on_unit_merge (hc, trackid0, pid0, name0, side0, nation0, oid0, orgname0, points0, strength0, HQ0, Leader0, trackid1, pid1, name1, side1, nation1, oid1, orgname1, points1, strength1, HQ1, Leader1) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_top (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_to_bottom (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_clockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------

function on_unit_counterclockwise (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE
    


end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_attack (hc, side, nation, attype) -- DO NOT REMOVE

--[[ commonly used; uncomment and adapt as necessary:
    -- lose EPs for indirect fire or airstrike vs. inhabited hex (village, city, suburb), whether or not occupied by the enemy
    -- side is the firing side
    if -- is_building_hex(hc) or
       is_habitat_hex(hc) then
        if not_occupied(hc, other_side(side)) then
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -2)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -5)
            end
        else -- occupied
            if attype == INDIRECTFIRE_COMBAT then
                inc_event_points(side, -1)
            elseif attype == AIRSTRIKE_COMBAT then
                inc_event_points(side, -2)
            end
        end
    end
--]]

end

------------------------------------------------------------------------------------------------------------------------ 

function on_hex_assault (hc, side) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_air_attack (hc, pid, name, side, nation, points, strength) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------

function on_arty_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE



end

------------------------------------------------------------------------------------------------------------------------ 

function on_mine_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_ied_attack (hc, trackid, pid, name, side, nation, oid, orgname, points, strength, HQ, Leader) -- DO NOT REMOVE 



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_vehicle_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_light_bridge (hc, dir, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_lay_mine_field (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_set_ied (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_build_barrier (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_damage (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_improve_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_entrench_hex (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_lz (hc, trackid, pid, name, side, nation, oid, orgname) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------

function on_clear_hex (hc) -- DO NOT REMOVE



end 

------------------------------------------------------------------------------------------------------------------------
